/*
 * Decompiled with CFR 0.152.
 */
package net.thauvin.erik.readingtime;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jsoup.Jsoup;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 -2\u00020\u0001:\u0001-BK\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010'\u001a\u00020\u0005H\u0002J\u0006\u0010(\u001a\u00020\u0003J\u0006\u0010)\u001a\u00020\u001eJ\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\tH\u0002R$\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R$\u0010\n\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0018\"\u0004\b\u001c\u0010\u001aR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0018\"\u0004\b$\u0010\u001aR$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0014\"\u0004\b&\u0010\u0016"}, d2={"Lnet/thauvin/erik/readingtime/ReadingTime;", "", "text", "", "wpm", "", "postfix", "plural", "excludeImages", "", "extra", "roundingMode", "Ljava/math/RoundingMode;", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;ZILjava/math/RoundingMode;)V", "value", "getExcludeImages", "()Z", "setExcludeImages", "(Z)V", "getExtra", "()I", "setExtra", "(I)V", "getPlural", "()Ljava/lang/String;", "setPlural", "(Ljava/lang/String;)V", "getPostfix", "setPostfix", "readTime", "", "getRoundingMode", "()Ljava/math/RoundingMode;", "setRoundingMode", "(Ljava/math/RoundingMode;)V", "getText", "setText", "getWpm", "setWpm", "calcImgReadingTime", "calcReadingTime", "calcReadingTimeInSec", "reset", "", "isChanged", "Companion"})
public final class ReadingTime {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String postfix;
    @NotNull
    private String plural;
    @NotNull
    private RoundingMode roundingMode;
    private double readTime;
    @NotNull
    private String text;
    private int wpm;
    private boolean excludeImages;
    private int extra;
    private static final double INVALID = -1.0;

    @JvmOverloads
    public ReadingTime(@NotNull String text, int wpm, @NotNull String postfix, @NotNull String plural, boolean excludeImages, int extra, @NotNull RoundingMode roundingMode) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)postfix, (String)"postfix");
        Intrinsics.checkNotNullParameter((Object)plural, (String)"plural");
        Intrinsics.checkNotNullParameter((Object)((Object)roundingMode), (String)"roundingMode");
        this.postfix = postfix;
        this.plural = plural;
        this.roundingMode = roundingMode;
        this.readTime = -1.0;
        this.text = text;
        this.wpm = wpm;
        this.excludeImages = excludeImages;
        this.extra = extra;
    }

    public /* synthetic */ ReadingTime(String string, int n, String string2, String string3, boolean bl, int n2, RoundingMode roundingMode, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = 275;
        }
        if ((n3 & 4) != 0) {
            string2 = "min read";
        }
        if ((n3 & 8) != 0) {
            string3 = "min read";
        }
        if ((n3 & 0x10) != 0) {
            bl = false;
        }
        if ((n3 & 0x20) != 0) {
            n2 = 0;
        }
        if ((n3 & 0x40) != 0) {
            roundingMode = RoundingMode.HALF_EVEN;
        }
        this(string, n, string2, string3, bl, n2, roundingMode);
    }

    @NotNull
    public final String getPostfix() {
        return this.postfix;
    }

    public final void setPostfix(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.postfix = string;
    }

    @NotNull
    public final String getPlural() {
        return this.plural;
    }

    public final void setPlural(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.plural = string;
    }

    @NotNull
    public final RoundingMode getRoundingMode() {
        return this.roundingMode;
    }

    public final void setRoundingMode(@NotNull RoundingMode roundingMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)roundingMode), (String)"<set-?>");
        this.roundingMode = roundingMode;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public final void setText(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.reset(!Intrinsics.areEqual((Object)value, (Object)this.text));
        this.text = value;
    }

    public final int getWpm() {
        return this.wpm;
    }

    public final void setWpm(int value) {
        this.reset(value != this.wpm);
        this.wpm = value;
    }

    public final boolean getExcludeImages() {
        return this.excludeImages;
    }

    public final void setExcludeImages(boolean value) {
        this.reset(value != this.excludeImages);
        this.excludeImages = value;
    }

    public final int getExtra() {
        return this.extra;
    }

    public final void setExtra(int value) {
        this.reset(value != this.extra);
        this.extra = value;
    }

    public final double calcReadingTimeInSec() {
        if (this.readTime == -1.0) {
            this.readTime = !this.excludeImages ? (double)this.calcImgReadingTime() : 0.0;
            this.readTime += (double)(Companion.wordCount(this.text) / this.wpm) * 60.0;
        }
        return this.readTime + (double)this.extra;
    }

    @NotNull
    public final String calcReadingTime() {
        BigDecimal time = new BigDecimal(this.calcReadingTimeInSec() / 60.0).setScale(0, this.roundingMode);
        return time.compareTo(BigDecimal.ONE) == 1 ? ((Object)StringsKt.trim((CharSequence)(time + " " + this.plural))).toString() : ((Object)StringsKt.trim((CharSequence)(time + " " + this.postfix))).toString();
    }

    private final int calcImgReadingTime() {
        int time = 0;
        int imgCount = Companion.imgCount(this.text);
        int offset = 12;
        int i = 1;
        if (i <= imgCount) {
            while (true) {
                if (i > 10) {
                    time += 3;
                } else {
                    time += offset;
                    --offset;
                }
                if (i == imgCount) break;
                ++i;
            }
        }
        return time;
    }

    private final void reset(boolean isChanged) {
        if (isChanged) {
            this.readTime = -1.0;
        }
    }

    @JvmOverloads
    public ReadingTime(@NotNull String text, int wpm, @NotNull String postfix, @NotNull String plural, boolean excludeImages, int extra) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)postfix, (String)"postfix");
        Intrinsics.checkNotNullParameter((Object)plural, (String)"plural");
        this(text, wpm, postfix, plural, excludeImages, extra, null, 64, null);
    }

    @JvmOverloads
    public ReadingTime(@NotNull String text, int wpm, @NotNull String postfix, @NotNull String plural, boolean excludeImages) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)postfix, (String)"postfix");
        Intrinsics.checkNotNullParameter((Object)plural, (String)"plural");
        this(text, wpm, postfix, plural, excludeImages, 0, null, 96, null);
    }

    @JvmOverloads
    public ReadingTime(@NotNull String text, int wpm, @NotNull String postfix, @NotNull String plural) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)postfix, (String)"postfix");
        Intrinsics.checkNotNullParameter((Object)plural, (String)"plural");
        this(text, wpm, postfix, plural, false, 0, null, 112, null);
    }

    @JvmOverloads
    public ReadingTime(@NotNull String text, int wpm, @NotNull String postfix) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)postfix, (String)"postfix");
        this(text, wpm, postfix, null, false, 0, null, 120, null);
    }

    @JvmOverloads
    public ReadingTime(@NotNull String text, int wpm) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this(text, wpm, null, null, false, 0, null, 124, null);
    }

    @JvmOverloads
    public ReadingTime(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this(text, 0, null, null, false, 0, null, 126, null);
    }

    @JvmStatic
    public static final int wordCount(@NotNull String words) {
        return Companion.wordCount(words);
    }

    @JvmStatic
    public static final int imgCount(@NotNull String html) {
        return Companion.imgCount(html);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000"}, d2={"Lnet/thauvin/erik/readingtime/ReadingTime$Companion;", "", "()V", "INVALID", "", "imgCount", "", "html", "", "wordCount", "words"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final int wordCount(@NotNull String words) {
            int n;
            Intrinsics.checkNotNullParameter((Object)words, (String)"words");
            String string = Jsoup.parse((String)words).text();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text(...)");
            String s = ((Object)StringsKt.trim((CharSequence)string)).toString();
            if (StringsKt.isBlank((CharSequence)s)) {
                n = 0;
            } else {
                CharSequence charSequence = s;
                Regex regex = new Regex("\\s+");
                int n2 = 0;
                n = regex.split(charSequence, n2).size();
            }
            return n;
        }

        @JvmStatic
        public final int imgCount(@NotNull String html) {
            Intrinsics.checkNotNullParameter((Object)html, (String)"html");
            return SequencesKt.count((Sequence)Regex.findAll$default((Regex)new Regex("<img ", RegexOption.IGNORE_CASE), (CharSequence)html, (int)0, (int)2, null));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

