/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.proxy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResultSetProxyLogic {
    private final Map<String, Integer> columnNameToIndex;
    private final ResultSet target;
    private final int columnCount;
    private int resultPointer;
    private boolean resultSetConsumed;
    private boolean closed;
    private Object[] currentResult;
    private final List<Object[]> cachedResults = new ArrayList<Object[]>();

    private ResultSetProxyLogic(Map<String, Integer> columnNameToIndex, ResultSet target, int columnCount) throws SQLException {
        this.columnNameToIndex = columnNameToIndex;
        this.target = target;
        this.columnCount = columnCount;
    }

    public static ResultSetProxyLogic resultSetProxyLogic(ResultSet target) throws SQLException {
        ResultSetMetaData metaData = target.getMetaData();
        int columnCount = metaData.getColumnCount();
        return new ResultSetProxyLogic(ResultSetProxyLogic.columnNameToIndex(metaData), target, columnCount);
    }

    private static Map<String, Integer> columnNameToIndex(ResultSetMetaData metaData) throws SQLException {
        HashMap<String, Integer> columnNameToIndex = new HashMap<String, Integer>();
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            columnNameToIndex.put(metaData.getColumnLabel(i).toUpperCase(), i);
        }
        return columnNameToIndex;
    }

    public Object invoke(Method method, Object[] args) throws Throwable {
        if (this.isGetTargetMethod(method)) {
            return this.target;
        }
        if (this.isGetMetaDataMethod(method)) {
            return method.invoke((Object)this.target, args);
        }
        if (this.isCloseMethod(method)) {
            this.closed = true;
            return method.invoke((Object)this.target, args);
        }
        if (this.closed) {
            throw new SQLException("Already closed");
        }
        if (this.resultSetConsumed) {
            if (this.isGetMethod(method)) {
                return this.handleGetMethodUsingCache(args);
            }
            if (this.isNextMethod(method)) {
                return this.handleNextMethodUsingCache();
            }
        } else {
            if (this.isGetMethod(method)) {
                return this.handleGetMethodByDelegating(method, args);
            }
            if (this.isNextMethod(method)) {
                return this.handleNextMethodByDelegating(method, args);
            }
            if (this.isBeforeFirstMethod(method)) {
                this.resultPointer = -1;
                this.resultSetConsumed = true;
                return null;
            }
        }
        throw new UnsupportedOperationException(String.format("Method '%s' is not supported by this proxy", method));
    }

    private Object handleNextMethodByDelegating(Method method, Object[] args) throws IllegalAccessException, InvocationTargetException {
        Object result = method.invoke((Object)this.target, args);
        if (Boolean.TRUE.equals(result)) {
            this.currentResult = new Object[this.columnCount + 1];
            this.cachedResults.add(this.currentResult);
        }
        return result;
    }

    private Object handleGetMethodByDelegating(Method method, Object[] args) throws SQLException, IllegalAccessException, InvocationTargetException {
        Object result;
        int columnIndex = this.determineColumnIndex(args);
        this.currentResult[columnIndex] = result = method.invoke((Object)this.target, args);
        return result;
    }

    private Object handleNextMethodUsingCache() {
        if (this.resultPointer < this.cachedResults.size() - 1) {
            ++this.resultPointer;
            this.currentResult = this.cachedResults.get(this.resultPointer);
            return true;
        }
        ++this.resultPointer;
        this.currentResult = null;
        return false;
    }

    private Object handleGetMethodUsingCache(Object[] args) throws SQLException {
        if (this.resultPointer == -1) {
            throw new SQLException("Result set not advanced. Call next before any get method!");
        }
        if (this.resultPointer < this.cachedResults.size()) {
            int columnIndex = this.determineColumnIndex(args);
            return this.currentResult[columnIndex];
        }
        throw new SQLException(String.format("Result set exhausted. There were %d result(s) only", this.cachedResults.size()));
    }

    private boolean isCloseMethod(Method method) {
        return method.getName().equals("close");
    }

    private boolean isGetTargetMethod(Method method) {
        return method.getName().equals("getTarget");
    }

    private boolean isGetMetaDataMethod(Method method) {
        return method.getName().equals("getMetaData");
    }

    private boolean isGetMethod(Method method) {
        return method.getName().startsWith("get") && method.getParameterTypes().length > 0;
    }

    private boolean isNextMethod(Method method) {
        return method.getName().equals("next");
    }

    private boolean isBeforeFirstMethod(Method method) {
        return method.getName().equals("beforeFirst");
    }

    private int determineColumnIndex(Object[] args) throws SQLException {
        Object lookup = args[0];
        if (lookup instanceof Integer) {
            return (Integer)lookup;
        }
        String columnName = (String)lookup;
        Integer indexForColumnName = this.columnNameToIndex(columnName);
        if (indexForColumnName != null) {
            return indexForColumnName;
        }
        throw new SQLException(String.format("Unknown column name '%s'", columnName));
    }

    private Integer columnNameToIndex(String columnName) {
        return this.columnNameToIndex.get(columnName.toUpperCase());
    }
}

