/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.contact.basicimpl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.wimpi.pim.contact.model.Communications;
import net.wimpi.pim.contact.model.EmailAddress;
import net.wimpi.pim.contact.model.PhoneNumber;

public class CommunicationsImpl
implements Communications {
    static final long serialVersionUID = 323095380120358187L;
    protected List m_PhoneNumbers = Collections.synchronizedList(new ArrayList(5));
    protected List m_EmailAddresses = Collections.synchronizedList(new ArrayList(5));
    protected String m_Mailer;
    protected EmailAddress m_PreferredEmail;
    protected PhoneNumber m_PreferredNumber;

    public Iterator getPhoneNumbers() {
        return this.m_PhoneNumbers.listIterator();
    }

    public PhoneNumber[] listPhoneNumbers() {
        PhoneNumber[] numbers = new PhoneNumber[this.m_PhoneNumbers.size()];
        return this.m_PhoneNumbers.toArray(numbers);
    }

    public PhoneNumber getPhoneNumber(String uid) {
        for (PhoneNumber number : this.m_PhoneNumbers) {
            if (!number.equals(uid)) continue;
            return number;
        }
        return null;
    }

    public void addPhoneNumber(PhoneNumber number) {
        this.m_PhoneNumbers.add(number);
    }

    public void removePhoneNumber(PhoneNumber number) {
        if (this.isPreferredPhoneNumber(number)) {
            this.m_PreferredNumber = null;
        }
        this.m_PhoneNumbers.remove(number);
    }

    public PhoneNumber getPreferredPhoneNumber() {
        return this.m_PreferredNumber;
    }

    public void setPreferredPhoneNumber(PhoneNumber number) {
        if (this.m_PhoneNumbers.contains(number)) {
            this.m_PreferredNumber = number;
        }
    }

    public boolean isPreferredPhoneNumber(PhoneNumber number) {
        return number.equals(this.m_PreferredNumber);
    }

    public PhoneNumber[] listPhoneNumbersByType(int TYPE) {
        ArrayList<PhoneNumber> list = new ArrayList<PhoneNumber>(this.m_PhoneNumbers.size());
        for (PhoneNumber num : this.m_PhoneNumbers) {
            if (!num.isType(TYPE)) continue;
            list.add(num);
        }
        PhoneNumber[] numbers = new PhoneNumber[list.size()];
        return list.toArray(numbers);
    }

    public int getPhoneNumberCount() {
        return this.m_PhoneNumbers.size();
    }

    public Iterator getEmailAddresses() {
        return this.m_EmailAddresses.listIterator();
    }

    public EmailAddress[] listEmailAddresses() {
        EmailAddress[] emails = new EmailAddress[this.m_EmailAddresses.size()];
        return this.m_EmailAddresses.toArray(emails);
    }

    public EmailAddress getEmailAddress(String uid) {
        for (EmailAddress addr : this.m_EmailAddresses) {
            if (!addr.equals(uid)) continue;
            return addr;
        }
        return null;
    }

    public void addEmailAddress(EmailAddress email) {
        this.m_EmailAddresses.add(email);
    }

    public void removeEmailAddress(EmailAddress email) {
        this.m_EmailAddresses.remove(email);
    }

    public EmailAddress getPreferredEmailAddress() {
        return this.m_PreferredEmail;
    }

    public void setPreferredEmailAddress(EmailAddress email) {
        if (this.m_EmailAddresses.contains(email)) {
            this.m_PreferredEmail = email;
        }
    }

    public boolean isPreferredEmailAddress(EmailAddress email) {
        return email.equals(this.m_PreferredEmail);
    }

    public int getEmailAddressCount() {
        return this.m_EmailAddresses.size();
    }

    public String getMailer() {
        return this.m_Mailer;
    }

    public void setMailer(String mailer) {
        this.m_Mailer = mailer;
    }
}

