/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.contact.basicimpl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import net.wimpi.pim.contact.model.Address;
import net.wimpi.pim.contact.model.Communications;
import net.wimpi.pim.contact.model.Contact;
import net.wimpi.pim.contact.model.Extensions;
import net.wimpi.pim.contact.model.GeographicalInformation;
import net.wimpi.pim.contact.model.Key;
import net.wimpi.pim.contact.model.OrganizationalIdentity;
import net.wimpi.pim.contact.model.PersonalIdentity;
import net.wimpi.pim.contact.model.Sound;
import net.wimpi.pim.util.AbstractIdentifiable;
import net.wimpi.pim.util.StringUtil;

public class ContactImpl
extends AbstractIdentifiable
implements Contact {
    static final long serialVersionUID = 5552536829541983668L;
    protected String m_Url;
    protected boolean m_Frequent = false;
    protected String m_Note;
    protected Date m_Revision;
    protected String m_Classification;
    protected List m_Addresses = Collections.synchronizedList(new ArrayList(5));
    protected List m_Categories = Collections.synchronizedList(new ArrayList(5));
    protected Address m_PreferredAddress;
    protected Address m_LastAddedAddress;
    protected PersonalIdentity m_PersonalIdentity;
    protected OrganizationalIdentity m_OrganizationalIdentity;
    protected Communications m_Communications;
    protected GeographicalInformation m_GeoInfo;
    protected Key m_Key;
    protected Sound m_Sound;
    protected Extensions m_Extensions;

    public PersonalIdentity getPersonalIdentity() {
        return this.m_PersonalIdentity;
    }

    public void setPersonalIdentity(PersonalIdentity identity) {
        this.m_PersonalIdentity = identity;
    }

    public boolean hasPersonalIdentity() {
        return this.m_PersonalIdentity != null;
    }

    public OrganizationalIdentity getOrganizationalIdentity() {
        return this.m_OrganizationalIdentity;
    }

    public void setOrganizationalIdentity(OrganizationalIdentity identity) {
        this.m_OrganizationalIdentity = identity;
    }

    public boolean hasOrganizationalIdentity() {
        return this.m_OrganizationalIdentity != null;
    }

    public Iterator getAddresses() {
        return this.m_Addresses.listIterator();
    }

    public Address[] listAddresses() {
        Address[] addr = new Address[this.m_Addresses.size()];
        return this.m_Addresses.toArray(addr);
    }

    public Address getAddress(String uid) {
        for (Address addr : this.m_Addresses) {
            if (!addr.equals(uid)) continue;
            return addr;
        }
        return null;
    }

    public Address getLastAddedAddress() {
        return this.m_LastAddedAddress;
    }

    public void addAddress(Address addr) {
        this.m_Addresses.add(addr);
        this.m_LastAddedAddress = addr;
    }

    public void removeAddress(Address addr) throws IndexOutOfBoundsException {
        if (this.isPreferredAddress(addr)) {
            this.m_PreferredAddress = null;
        }
        this.m_Addresses.remove(addr);
    }

    public Address getPreferredAddress() {
        return this.m_PreferredAddress;
    }

    public void setPreferredAddress(Address address) {
        if (this.m_Addresses.contains(address)) {
            this.m_PreferredAddress = address;
        }
    }

    public boolean isPreferredAddress(Address address) {
        return address.equals(this.m_PreferredAddress);
    }

    public int getAddressCount() {
        return this.m_Addresses.size();
    }

    public Address[] listAddressesByType(int TYPE) {
        ArrayList<Address> list = new ArrayList<Address>(this.m_Addresses.size());
        for (Address addr : this.m_Addresses) {
            if (!addr.isType(TYPE)) continue;
            list.add(addr);
        }
        Address[] addrs = new Address[list.size()];
        return list.toArray(addrs);
    }

    public Communications getCommunications() {
        return this.m_Communications;
    }

    public void setCommunications(Communications communications) {
        this.m_Communications = communications;
    }

    public boolean hasCommunications() {
        return this.m_Communications != null;
    }

    public GeographicalInformation getGeographicalInformation() {
        return this.m_GeoInfo;
    }

    public void setGeographicalInformation(GeographicalInformation geoinfo) {
        this.m_GeoInfo = geoinfo;
    }

    public boolean hasGeographicalInformation() {
        return this.m_GeoInfo != null;
    }

    public String getCategoriesList() {
        return StringUtil.joinList(this.listCategories());
    }

    public void setCategoriesList(String list) {
        String[] cats = StringUtil.splitList(list);
        this.m_Categories.clear();
        for (int i = 0; i < cats.length; ++i) {
            this.addCategory(cats[i]);
        }
    }

    public String[] listCategories() {
        String[] cats = new String[this.m_Categories.size()];
        return this.m_Categories.toArray(cats);
    }

    public String getCategory(int index) throws IndexOutOfBoundsException {
        return (String)this.m_Categories.get(index);
    }

    public String setCategory(int index, String cat) {
        return this.m_Categories.set(index, cat);
    }

    public void addCategory(String category) {
        this.m_Categories.add(category);
    }

    public String removeCategory(int index) throws IndexOutOfBoundsException {
        return (String)this.m_Categories.remove(index);
    }

    public void removeAllCategories() {
        this.m_Categories.clear();
    }

    public int getCategoryCount() {
        return this.m_Categories.size();
    }

    public String getURL() {
        return this.m_Url;
    }

    public void setURL(String url) {
        this.m_Url = url;
    }

    public boolean isFrequent() {
        return this.m_Frequent;
    }

    public void setFrequent(boolean b) {
        this.m_Frequent = b;
    }

    public String getNote() {
        return this.m_Note;
    }

    public void setNote(String note) {
        this.m_Note = note;
    }

    public Date getCurrentRevisionDate() {
        return this.m_Revision;
    }

    public void setCurrentRevisionDate(Date revision) {
        this.m_Revision = revision;
    }

    public String getAccessClassification() {
        return this.m_Classification;
    }

    public void setAccessClassification(String classification) {
        this.m_Classification = classification;
    }

    public Key getPublicKey() {
        return this.m_Key;
    }

    public void setPublicKey(Key key) {
        this.m_Key = key;
    }

    public boolean hasPublicKey() {
        return this.m_Key != null;
    }

    public Sound getSound() {
        return this.m_Sound;
    }

    public void setSound(Sound sound) {
        this.m_Sound = sound;
    }

    public boolean hasSound() {
        return this.m_Sound != null;
    }

    public Extensions getExtensions() {
        return this.m_Extensions;
    }

    public void setExtensions(Extensions extensions) {
        this.m_Extensions = extensions;
    }

    public boolean hasExtensions() {
        return this.m_Extensions != null;
    }
}

