/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.contact.db.serializable;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import net.wimpi.pim.contact.db.ContactGroup;
import net.wimpi.pim.contact.db.ContactGroupCollection;
import net.wimpi.pim.contact.db.ContactGroupFilter;

public class ContactGroupCollectionImpl
implements ContactGroupCollection,
Serializable {
    static final long serialVersionUID = 7926133701871079538L;
    protected Map m_Groups = new HashMap(50);
    protected Map m_NameIndex = new HashMap(50);
    protected transient int m_ModCount = 0;

    public boolean contains(String UID) {
        return this.m_Groups.keySet().contains(UID);
    }

    public boolean contains(ContactGroup group) {
        return this.contains(group.getUID());
    }

    public boolean containsByName(String name) {
        return this.m_NameIndex.keySet().contains(name);
    }

    public ContactGroup get(String UID) {
        return (ContactGroup)this.m_Groups.get(UID);
    }

    public ContactGroup getByName(String name) {
        return this.get((String)this.m_NameIndex.get(name));
    }

    public ContactGroup[] toArray() {
        ContactGroup[] groups = new ContactGroup[this.m_Groups.size()];
        Iterator iter = this.iterator();
        for (int i = 0; i < this.m_Groups.size(); ++i) {
            groups[i] = (ContactGroup)iter.next();
        }
        return groups;
    }

    public ContactGroup[] toArray(ContactGroupFilter filter) {
        GroupIterator iter = new GroupIterator(filter);
        ContactGroup[] groups = new ContactGroup[iter.size()];
        for (int i = 0; i < iter.size(); ++i) {
            groups[i] = (ContactGroup)iter.next();
        }
        return groups;
    }

    public boolean add(ContactGroup group) {
        if (this.containsByName(group.getName())) {
            return false;
        }
        int size = this.size();
        this.m_Groups.put(group.getUID(), group);
        this.addToNameIndex(group);
        if (size != this.size()) {
            this.m_ModCount = this.m_ModCount == Integer.MAX_VALUE ? 0 : ++this.m_ModCount;
        }
        return true;
    }

    public ContactGroup remove(String UID) {
        ContactGroup group = (ContactGroup)this.m_Groups.remove(UID);
        if (group != null) {
            this.removeFromNameIndex(group);
            this.m_ModCount = this.m_ModCount == Integer.MAX_VALUE ? 0 : ++this.m_ModCount;
        }
        return group;
    }

    public void remove(ContactGroup group) {
        this.remove(group.getUID());
    }

    public Iterator iterator() {
        return new GroupIterator();
    }

    public Iterator iterator(ContactGroupFilter filter) {
        return new GroupIterator(filter);
    }

    public int size() {
        return this.m_Groups.size();
    }

    private void addToNameIndex(ContactGroup group) {
        if (group == null) {
            return;
        }
        String name = group.getName();
        if (name != null && name.length() > 0) {
            this.m_NameIndex.put(name, group.getUID());
        }
    }

    private void removeFromNameIndex(ContactGroup group) {
        if (group == null) {
            return;
        }
        String name = group.getName();
        if (name != null && name.length() > 0) {
            this.m_NameIndex.remove(name);
        }
    }

    private boolean modified(int modcount) {
        return modcount != this.m_ModCount;
    }

    class GroupIterator
    implements Iterator {
        private ArrayList m_Entries;
        private int m_Next;
        private int m_Last = -1;
        private int m_ExpectedModCount;

        public GroupIterator() {
            this.m_ExpectedModCount = ContactGroupCollectionImpl.this.m_ModCount;
            this.prepare(null);
        }

        public GroupIterator(ContactGroupFilter filter) {
            this.m_ExpectedModCount = ContactGroupCollectionImpl.this.m_ModCount;
            this.prepare(filter);
        }

        private void prepare(ContactGroupFilter filter) {
            int size = ContactGroupCollectionImpl.this.size();
            this.m_Entries = new ArrayList(size);
            Iterator iter = ContactGroupCollectionImpl.this.m_Groups.values().iterator();
            for (int i = 0; i < size; ++i) {
                ContactGroup group = (ContactGroup)iter.next();
                if (filter != null) {
                    if (!filter.passes(group)) continue;
                    this.m_Entries.add(group);
                    continue;
                }
                this.m_Entries.add(group);
            }
            this.m_Next = 0;
        }

        public boolean hasNext() {
            return this.m_Next < this.m_Entries.size();
        }

        public Object next() {
            if (this.m_Next >= this.m_Entries.size()) {
                throw new NoSuchElementException();
            }
            if (ContactGroupCollectionImpl.this.modified(this.m_ExpectedModCount)) {
                throw new ConcurrentModificationException();
            }
            Object rv = this.m_Entries.get(this.m_Next);
            this.m_Last = this.m_Next++;
            return rv;
        }

        public void remove() {
            if (this.m_Last == -1) {
                throw new IllegalStateException();
            }
            ContactGroupCollectionImpl.this.remove((ContactGroup)this.m_Entries.get(this.m_Last));
            this.m_Entries.remove(this.m_Last);
            this.m_Last = -1;
            --this.m_Next;
            ++this.m_ExpectedModCount;
        }

        public int size() {
            return this.m_Entries.size();
        }
    }
}

