/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.contact.io.vcard;

import java.math.BigDecimal;
import net.wimpi.pim.Pim;
import net.wimpi.pim.contact.io.vcard.ItemHandler;
import net.wimpi.pim.contact.model.Contact;
import net.wimpi.pim.contact.model.GeographicalInformation;
import net.wimpi.pim.util.StringUtil;
import net.wimpi.pim.util.versitio.versitItem;

class GEOItemHandler
implements ItemHandler {
    GEOItemHandler() {
    }

    public void handleItem(Contact ct, versitItem item) {
        GeographicalInformation geo = ct.getGeographicalInformation();
        if (geo == null) {
            geo = Pim.getContactModelFactory().createGeographicalInformation();
            ct.setGeographicalInformation(geo);
        }
        String[] comps = StringUtil.split(item.getDecodedValue(), ";");
        geo.setLatitude(new BigDecimal(comps[0]));
        geo.setLongitude(new BigDecimal(comps[1]));
    }

    public versitItem[] createItems(Contact ct) {
        GeographicalInformation geo = ct.getGeographicalInformation();
        if (geo == null) {
            return new versitItem[0];
        }
        versitItem[] items = new versitItem[1];
        BigDecimal longitude = geo.getLongitude();
        BigDecimal latitude = geo.getLatitude();
        if (longitude.compareTo(BigDecimal.ZERO) == 0 && latitude.compareTo(BigDecimal.ZERO) == 0) {
            return new versitItem[0];
        }
        versitItem item = new versitItem("GEO");
        item.setValue(latitude + "," + longitude);
        items[0] = item;
        return items;
    }
}

