/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.contact.io.vcard;

import java.util.Iterator;
import net.wimpi.pim.Pim;
import net.wimpi.pim.contact.basicimpl.GenericExtension;
import net.wimpi.pim.contact.io.vcard.ItemHandler;
import net.wimpi.pim.contact.model.Contact;
import net.wimpi.pim.contact.model.Extensions;
import net.wimpi.pim.util.versitio.versitItem;

public class GenericExtensionItemHandler
implements ItemHandler {
    protected String m_Identifier;
    protected GenericExtension m_Type;

    public GenericExtensionItemHandler(GenericExtension ext) {
        this.m_Identifier = ext.getIdentifier();
        this.m_Type = ext;
    }

    public void handleItem(Contact ct, versitItem item) {
        Extensions extensions = ct.getExtensions();
        if (extensions == null) {
            extensions = Pim.getContactModelFactory().createExtensions();
            ct.setExtensions(extensions);
        }
        GenericExtension ext = this.m_Type.createExtension();
        ext.setValue(item.getDecodedValue());
        ext.setParameters(item.getParameters());
        extensions.add(ext);
    }

    public versitItem[] createItems(Contact ct) {
        Extensions extensions = ct.getExtensions();
        if (extensions == null) {
            return new versitItem[0];
        }
        versitItem[] items = new versitItem[extensions.size(this.m_Identifier)];
        int n = 0;
        Iterator iter = extensions.iterator(this.m_Identifier);
        while (iter.hasNext()) {
            GenericExtension ext = (GenericExtension)iter.next();
            versitItem item = new versitItem(this.m_Identifier);
            item.setValue(ext.getValue());
            String[] params = ext.listParameters();
            for (int i = 0; i < params.length; ++i) {
                String[] paramvals = ext.getParameterValues(params[i]);
                for (int j = 0; j < paramvals.length; ++j) {
                    item.addParameter(params[i], paramvals[j]);
                }
            }
            items[n] = item;
            ++n;
        }
        return items;
    }
}

