/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.contact.io.vcard;

import net.wimpi.pim.Pim;
import net.wimpi.pim.contact.io.vcard.ItemHandler;
import net.wimpi.pim.contact.model.Contact;
import net.wimpi.pim.contact.model.Image;
import net.wimpi.pim.contact.model.PersonalIdentity;
import net.wimpi.pim.util.EncodingUtility;
import net.wimpi.pim.util.versitio.versitItem;

class PHOTOItemHandler
implements ItemHandler {
    PHOTOItemHandler() {
    }

    public void handleItem(Contact ct, versitItem item) {
        Image photo = Pim.getContactModelFactory().createImage();
        String[] paramvalues = null;
        paramvalues = item.getParameter("VALUE");
        if (paramvalues != null && (paramvalues[0].equalsIgnoreCase("URL") || paramvalues[0].equalsIgnoreCase("URI"))) {
            photo.setURI(item.getDecodedValue());
        } else {
            paramvalues = item.getParameter("ENCODING");
            if (paramvalues != null && (paramvalues[0].equalsIgnoreCase("B") || paramvalues[0].equalsIgnoreCase("BASE64"))) {
                photo.setData(EncodingUtility.decodeBase64(EncodingUtility.removeWhiteSpace(item.getValue().getBytes())));
            }
            if ((paramvalues = item.getParameter("TYPE")) == null) {
                paramvalues = item.getParameter("DEFAULT");
            }
            if (paramvalues != null) {
                photo.setContentType("image/" + paramvalues[0].toLowerCase());
            }
        }
        PersonalIdentity pid = ct.getPersonalIdentity();
        if (pid == null) {
            pid = Pim.getContactModelFactory().createPersonalIdentity();
            ct.setPersonalIdentity(pid);
        }
        pid.setPhoto(photo);
    }

    public versitItem[] createItems(Contact ct) {
        if (!ct.hasPersonalIdentity()) {
            return new versitItem[0];
        }
        if (!ct.getPersonalIdentity().hasPhoto()) {
            return new versitItem[0];
        }
        versitItem[] items = new versitItem[1];
        Image photo = ct.getPersonalIdentity().getPhoto();
        if (photo == null) {
            return new versitItem[0];
        }
        versitItem item = new versitItem("PHOTO");
        if (photo.isURI()) {
            item.addParameter("VALUE", "URI");
            item.setValue(photo.getURI());
        } else {
            String ctype = photo.getContentType();
            ctype = ctype.substring(ctype.indexOf("/") + 1, ctype.length()).toUpperCase();
            item.addParameter("ENCODING", "B");
            item.addParameter("TYPE", ctype);
            item.setValue(new String(EncodingUtility.removeWhiteSpace(EncodingUtility.encodeBase64(photo.getData()))));
        }
        items[0] = item;
        return items;
    }
}

