/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.util;

public class QuotedPrintable {
    private QuotedPrintable() {
    }

    public static final String encode(String data) {
        byte[] b = null;
        try {
            b = data.getBytes("ISOLatin1");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            b = data.getBytes();
        }
        int len = b.length;
        StringBuffer buffer = new StringBuffer(2 * len);
        StringBuffer line = new StringBuffer(240);
        StringBuffer white = new StringBuffer(80);
        for (int i = 0; i < len; ++i) {
            char c = (char)b[i];
            if (c == '\r' && i != len - 1 && b[i + 1] == 10) {
                QuotedPrintable.encodeEndOfLine(buffer, line, white);
                ++i;
                continue;
            }
            if (c == ' ' || c == '\t') {
                white.append(c);
                continue;
            }
            if (white.length() != 0) {
                line.append(white);
                white.setLength(0);
            }
            if (c >= '!' && c <= '~' && c != '=') {
                line.append(c);
                continue;
            }
            QuotedPrintable.appendHex(line, c);
        }
        if (line.length() != 0 || white.length() != 0) {
            QuotedPrintable.encodeEndOfLine(buffer, line, white);
        }
        return buffer.toString();
    }

    private static final void encodeEndOfLine(StringBuffer buffer, StringBuffer line, StringBuffer white) {
        int i;
        for (i = 0; i < white.length(); ++i) {
            QuotedPrintable.appendHex(line, white.charAt(i));
        }
        String s = line.toString();
        int len = s.length();
        boolean split = false;
        i = 0;
        while (i < len) {
            int j = i + 75;
            if (j == len - 1 || j > len) {
                j = len;
            }
            if (j > 2) {
                if (s.charAt(j - 1) == '=') {
                    --j;
                }
                if (s.charAt(j - 2) == '=') {
                    j -= 2;
                }
            }
            buffer.append(s.substring(i, j));
            if (j != len) {
                buffer.append('=');
            }
            buffer.append("\r\n");
            i = j;
        }
        line.setLength(0);
        white.setLength(0);
    }

    private static final void appendHex(StringBuffer line, int c) {
        line.append('=');
        line.append("0123456789ABCDEF".charAt((c &= 0xFF) >> 4));
        line.append("0123456789ABCDEF".charAt(c & 0xF));
    }

    public static final String decode(String s) {
        StringBuffer buffer = new StringBuffer(s.length());
        StringBuffer white = new StringBuffer(80);
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '=' && i + 2 < len) {
                char a = s.charAt(++i);
                char b = s.charAt(++i);
                if (a == '\r' && b == '\n') continue;
                int ah = "0123456789ABCDEF".indexOf(a);
                int bh = "0123456789ABCDEF".indexOf(b);
                if (ah == -1 || bh == -1) {
                    buffer.append('=');
                    buffer.append(a);
                    buffer.append(b);
                    continue;
                }
                buffer.append((char)(ah << 4 | bh));
                continue;
            }
            if (c == ' ' || c == '\t') {
                white.append(c);
                continue;
            }
            if (white.length() != 0) {
                buffer.append(white);
            }
            buffer.append(c);
            white.setLength(0);
        }
        return buffer.toString();
    }
}

