/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.util;

import java.io.DataInputStream;
import java.net.URL;
import java.rmi.server.UID;
import java.security.SecureRandom;
import net.wimpi.pim.util.MD5;

public class UIDGenerator {
    private static SecureRandom c_Random;
    private static SecureRandom c_SeedRandom;
    private static int c_ReseedCounter;
    private static boolean c_SeedWithHotBits;
    public static final int RANDOM_PADDING = 256;
    public static final int RANDOM_SEED_LENGTH = 6;
    public static final int RANDOM_RESEED = 1000;
    public static final String HOTBITS_URL = "http://www.fourmilab.ch/cgi-bin/uncgi/Hotbits?nbytes=6&fmt=bin";

    public static final synchronized String getUID() {
        byte[] buffer = new byte[256];
        String u = new UID().toString();
        int i = System.identityHashCode(u);
        long d = System.currentTimeMillis();
        c_Random.nextBytes(buffer);
        u = u + new String(buffer);
        if (c_ReseedCounter == 1000) {
            UIDGenerator.seedRandom();
            c_ReseedCounter = 0;
        } else {
            ++c_ReseedCounter;
        }
        return MD5.hash(u + i + d);
    }

    public static final void seedRandom() {
        if (c_SeedWithHotBits) {
            try {
                URL url = new URL(HOTBITS_URL);
                DataInputStream din = new DataInputStream(url.openStream());
                c_Random.setSeed(din.readLong());
                din.close();
            }
            catch (Exception ex) {
                c_Random.setSeed(SecureRandom.getSeed(8));
            }
        } else {
            c_Random.setSeed(SecureRandom.getSeed(8));
        }
    }

    public static final void main(String[] args) {
        System.out.println("Seed with Hotbits = " + c_SeedWithHotBits);
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1000; ++i) {
            System.out.println(UIDGenerator.getUID());
        }
        long stop = System.currentTimeMillis();
        System.out.println("Time =" + (stop - start) + "[ms]");
    }

    static {
        c_ReseedCounter = 0;
        c_SeedWithHotBits = false;
        c_Random = new SecureRandom();
        c_SeedRandom = new SecureRandom();
        c_SeedWithHotBits = new Boolean(System.getProperty("jpim.uidgen.hotbits", "false"));
        UIDGenerator.seedRandom();
    }
}

