/*
 * Decompiled with CFR 0.152.
 */
package net.sqlcipher.database;

import android.database.DataSetObserver;
import android.os.Handler;
import android.os.Message;
import android.os.Process;
import android.text.TextUtils;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import net.sqlcipher.AbstractWindowedCursor;
import net.sqlcipher.CursorWindow;
import net.sqlcipher.SQLException;
import net.sqlcipher.database.DatabaseObjectNotClosedException;
import net.sqlcipher.database.SQLiteCursorDriver;
import net.sqlcipher.database.SQLiteDatabase;
import net.sqlcipher.database.SQLiteDebug;
import net.sqlcipher.database.SQLiteQuery;

public class SQLiteCursor
extends AbstractWindowedCursor {
    static final String TAG = "Cursor";
    static final int NO_COUNT = -1;
    private String mEditTable;
    private String[] mColumns;
    private SQLiteQuery mQuery;
    private SQLiteDatabase mDatabase;
    private SQLiteCursorDriver mDriver;
    private int mCount = -1;
    private int mCursorWindowCapacity = 0;
    private boolean fillWindowForwardOnly = false;
    private Map<String, Integer> mColumnNameMap;
    private Throwable mStackTrace;
    private int mMaxRead = Integer.MAX_VALUE;
    private int mInitialRead = Integer.MAX_VALUE;
    private int mCursorState = 0;
    private ReentrantLock mLock = null;
    private boolean mPendingData = false;
    protected MainThreadNotificationHandler mNotificationHandler;

    public void setFillWindowForwardOnly(boolean value) {
        this.fillWindowForwardOnly = value;
    }

    public void setLoadStyle(int initialRead, int maxRead) {
        this.mMaxRead = maxRead;
        this.mInitialRead = initialRead;
        this.mLock = new ReentrantLock(true);
    }

    private void queryThreadLock() {
        if (this.mLock != null) {
            this.mLock.lock();
        }
    }

    private void queryThreadUnlock() {
        if (this.mLock != null) {
            this.mLock.unlock();
        }
    }

    @Override
    public void registerDataSetObserver(DataSetObserver observer) {
        super.registerDataSetObserver(observer);
        if ((Integer.MAX_VALUE != this.mMaxRead || Integer.MAX_VALUE != this.mInitialRead) && this.mNotificationHandler == null) {
            this.queryThreadLock();
            try {
                this.mNotificationHandler = new MainThreadNotificationHandler(this);
                if (this.mPendingData) {
                    this.notifyDataSetChange();
                    this.mPendingData = false;
                }
            }
            finally {
                this.queryThreadUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLiteCursor(SQLiteDatabase db, SQLiteCursorDriver driver, String editTable, SQLiteQuery query) {
        this.mStackTrace = new DatabaseObjectNotClosedException().fillInStackTrace();
        this.mDatabase = db;
        this.mDriver = driver;
        this.mEditTable = editTable;
        this.mColumnNameMap = null;
        this.mQuery = query;
        try {
            db.lock();
            int columnCount = this.mQuery.columnCountLocked();
            this.mColumns = new String[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                String columnName;
                this.mColumns[i] = columnName = this.mQuery.columnNameLocked(i);
                if (!"_id".equals(columnName)) continue;
                this.mRowIdColumnIndex = i;
            }
        }
        finally {
            db.unlock();
        }
    }

    public SQLiteDatabase getDatabase() {
        return this.mDatabase;
    }

    @Override
    public boolean onMove(int oldPosition, int newPosition) {
        if (this.mWindow == null || newPosition < this.mWindow.getStartPosition() || newPosition >= this.mWindow.getStartPosition() + this.mWindow.getNumRows()) {
            this.fillWindow(newPosition);
        }
        return true;
    }

    @Override
    public int getCount() {
        if (this.mCount == -1) {
            this.fillWindow(0);
        }
        return this.mCount;
    }

    private void fillWindow(int requiredPos) {
        int startPos = 0;
        if (this.mWindow == null) {
            this.mWindow = new CursorWindow(true);
        } else {
            ++this.mCursorState;
            this.queryThreadLock();
            try {
                this.mWindow.clear();
            }
            finally {
                this.queryThreadUnlock();
            }
        }
        startPos = this.fillWindowForwardOnly ? requiredPos : (this.mCount == -1 ? this.cursorPickFillWindowStartPosition(requiredPos, 0) : this.cursorPickFillWindowStartPosition(requiredPos, this.mCursorWindowCapacity));
        this.mWindow.setStartPosition(startPos);
        this.mWindow.setRequiredPosition(requiredPos);
        this.mCount = this.mQuery.fillWindow(this.mWindow, this.mInitialRead, 0);
        if (this.mCursorWindowCapacity == 0) {
            this.mCursorWindowCapacity = this.mWindow.getNumRows();
        }
        if (this.mCount == -1) {
            this.mCount = startPos + this.mInitialRead;
            Thread t = new Thread((Runnable)new QueryThread(this.mCursorState), "query thread");
            t.start();
        }
    }

    @Override
    public int getColumnIndex(String columnName) {
        Integer i;
        int periodIndex;
        if (this.mColumnNameMap == null) {
            String[] columns = this.mColumns;
            int columnCount = columns.length;
            HashMap<String, Integer> map = new HashMap<String, Integer>(columnCount, 1.0f);
            for (int i2 = 0; i2 < columnCount; ++i2) {
                map.put(columns[i2], i2);
            }
            this.mColumnNameMap = map;
        }
        if ((periodIndex = columnName.lastIndexOf(46)) != -1) {
            Exception columnCount = new Exception();
        }
        if ((i = this.mColumnNameMap.get(columnName)) != null) {
            return i;
        }
        return -1;
    }

    @Override
    public boolean deleteRow() {
        boolean success;
        this.checkPosition();
        if (this.mRowIdColumnIndex == -1 || this.mCurrentRowID == null) {
            return false;
        }
        this.mDatabase.lock();
        try {
            try {
                this.mDatabase.delete(this.mEditTable, this.mColumns[this.mRowIdColumnIndex] + "=?", new String[]{this.mCurrentRowID.toString()});
                success = true;
            }
            catch (SQLException e) {
                success = false;
            }
            int pos = this.mPos;
            this.requery();
            this.moveToPosition(pos);
        }
        finally {
            this.mDatabase.unlock();
        }
        if (success) {
            this.onChange(true);
            return true;
        }
        return false;
    }

    @Override
    public String[] getColumnNames() {
        return this.mColumns;
    }

    @Override
    public boolean supportsUpdates() {
        return !TextUtils.isEmpty((CharSequence)this.mEditTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commitUpdates(Map<? extends Long, ? extends Map<String, Object>> additionalValues) {
        if (!this.supportsUpdates()) {
            return false;
        }
        HashMap hashMap = this.mUpdatedRows;
        synchronized (hashMap) {
            if (additionalValues != null) {
                this.mUpdatedRows.putAll(additionalValues);
            }
            if (this.mUpdatedRows.size() == 0) {
                return true;
            }
            this.mDatabase.beginTransaction();
            try {
                StringBuilder sql = new StringBuilder(128);
                for (Map.Entry rowEntry : this.mUpdatedRows.entrySet()) {
                    Map values = (Map)rowEntry.getValue();
                    Long rowIdObj = (Long)rowEntry.getKey();
                    if (rowIdObj == null || values == null) {
                        throw new IllegalStateException("null rowId or values found! rowId = " + rowIdObj + ", values = " + values);
                    }
                    if (values.size() == 0) continue;
                    long rowId = rowIdObj;
                    Iterator valuesIter = values.entrySet().iterator();
                    sql.setLength(0);
                    sql.append("UPDATE " + this.mEditTable + " SET ");
                    Object[] bindings = new Object[values.size()];
                    int i = 0;
                    while (valuesIter.hasNext()) {
                        Map.Entry entry = valuesIter.next();
                        sql.append((String)entry.getKey());
                        sql.append("=?");
                        bindings[i] = entry.getValue();
                        if (valuesIter.hasNext()) {
                            sql.append(", ");
                        }
                        ++i;
                    }
                    sql.append(" WHERE " + this.mColumns[this.mRowIdColumnIndex] + '=' + rowId);
                    sql.append(';');
                    this.mDatabase.execSQL(sql.toString(), bindings);
                    this.mDatabase.rowUpdated(this.mEditTable, rowId);
                }
                this.mDatabase.setTransactionSuccessful();
            }
            finally {
                this.mDatabase.endTransaction();
            }
            this.mUpdatedRows.clear();
        }
        this.onChange(true);
        return true;
    }

    private void deactivateCommon() {
        this.mCursorState = 0;
        if (this.mWindow != null) {
            this.mWindow.close();
            this.mWindow = null;
        }
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.deactivateCommon();
        this.mDriver.cursorDeactivated();
    }

    @Override
    public void close() {
        super.close();
        this.deactivateCommon();
        this.mQuery.close();
        this.mDriver.cursorClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean requery() {
        if (this.isClosed()) {
            return false;
        }
        long timeStart = 0L;
        this.mDatabase.lock();
        try {
            if (this.mWindow != null) {
                this.mWindow.clear();
            }
            this.mPos = -1;
            this.mDriver.cursorRequeried(this);
            this.mCount = -1;
            ++this.mCursorState;
            this.queryThreadLock();
            try {
                this.mQuery.requery();
            }
            finally {
                this.queryThreadUnlock();
            }
        }
        finally {
            this.mDatabase.unlock();
        }
        boolean result = super.requery();
        return result;
    }

    @Override
    public void setWindow(CursorWindow window) {
        if (this.mWindow != null) {
            ++this.mCursorState;
            this.queryThreadLock();
            try {
                this.mWindow.close();
            }
            finally {
                this.queryThreadUnlock();
            }
            this.mCount = -1;
        }
        this.mWindow = window;
    }

    public void setSelectionArguments(String[] selectionArgs) {
        this.mDriver.setBindArguments(selectionArgs);
    }

    @Override
    protected void finalize() {
        try {
            if (this.mWindow != null) {
                int len = this.mQuery.mSql.length();
                this.close();
                SQLiteDebug.notifyActiveCursorFinalized();
            }
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillWindow(int requiredPos, android.database.CursorWindow window) {
        int startPos = 0;
        if (this.mWindow == null) {
            this.mWindow = new CursorWindow(true);
        } else {
            ++this.mCursorState;
            this.queryThreadLock();
            try {
                this.mWindow.clear();
            }
            finally {
                this.queryThreadUnlock();
            }
        }
        startPos = this.fillWindowForwardOnly ? requiredPos : (this.mCount == -1 ? this.cursorPickFillWindowStartPosition(requiredPos, 0) : this.cursorPickFillWindowStartPosition(requiredPos, this.mCursorWindowCapacity));
        this.mWindow.setStartPosition(startPos);
        this.mWindow.setRequiredPosition(requiredPos);
        this.mCount = this.mQuery.fillWindow(this.mWindow, this.mInitialRead, 0);
        if (this.mCursorWindowCapacity == 0) {
            this.mCursorWindowCapacity = this.mWindow.getNumRows();
        }
        if (this.mCount == -1) {
            this.mCount = startPos + this.mInitialRead;
            Thread t = new Thread((Runnable)new QueryThread(this.mCursorState), "query thread");
            t.start();
        }
    }

    public int cursorPickFillWindowStartPosition(int cursorPosition, int cursorWindowCapacity) {
        return Math.max(cursorPosition - cursorWindowCapacity / 3, 0);
    }

    protected static class MainThreadNotificationHandler
    extends Handler {
        private final WeakReference<SQLiteCursor> wrappedCursor;

        MainThreadNotificationHandler(SQLiteCursor cursor) {
            this.wrappedCursor = new WeakReference<SQLiteCursor>(cursor);
        }

        public void handleMessage(Message msg) {
            SQLiteCursor cursor = (SQLiteCursor)this.wrappedCursor.get();
            if (cursor != null) {
                cursor.notifyDataSetChange();
            }
        }
    }

    private final class QueryThread
    implements Runnable {
        private final int mThreadState;

        QueryThread(int version) {
            this.mThreadState = version;
        }

        private void sendMessage() {
            if (SQLiteCursor.this.mNotificationHandler != null) {
                SQLiteCursor.this.mNotificationHandler.sendEmptyMessage(1);
                SQLiteCursor.this.mPendingData = false;
            } else {
                SQLiteCursor.this.mPendingData = true;
            }
        }

        @Override
        public void run() {
            CursorWindow cw = SQLiteCursor.this.mWindow;
            Process.setThreadPriority((int)Process.myTid(), (int)10);
            while (true) {
                if (SQLiteCursor.this.mLock == null) {
                    SQLiteCursor.this.mLock = new ReentrantLock(true);
                }
                SQLiteCursor.this.mLock.lock();
                if (SQLiteCursor.this.mCursorState != this.mThreadState) {
                    SQLiteCursor.this.mLock.unlock();
                    break;
                }
                try {
                    int count = SQLiteCursor.this.mQuery.fillWindow(cw, SQLiteCursor.this.mMaxRead, SQLiteCursor.this.mCount);
                    if (count == 0) break;
                    if (count == -1) {
                        SQLiteCursor.this.mCount += SQLiteCursor.this.mMaxRead;
                        this.sendMessage();
                        continue;
                    }
                    SQLiteCursor.this.mCount = count;
                    this.sendMessage();
                }
                catch (Exception e) {
                }
                finally {
                    SQLiteCursor.this.mLock.unlock();
                    continue;
                }
                break;
            }
        }
    }
}

