/*
 * Decompiled with CFR 0.152.
 */
package net.zetetic.database;

import net.zetetic.database.LogTarget;
import net.zetetic.database.LogcatTarget;
import net.zetetic.database.NoopTarget;

public class Logger {
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    public static final int ASSERT = 7;
    private static LogTarget target;

    public static void setTarget(LogTarget target) {
        Logger.target = target;
    }

    private static LogTarget getTarget() {
        if (target == null) {
            Logger.setTarget(new NoopTarget());
        }
        return target;
    }

    public static boolean isLoggable(String tag, int priority) {
        return Logger.getTarget().isLoggable(tag, priority);
    }

    public static void i(String tag, String message) {
        Logger.getTarget().log(4, tag, message, null);
    }

    public static void i(String tag, String message, Throwable throwable) {
        Logger.getTarget().log(4, tag, message, throwable);
    }

    public static void d(String tag, String message) {
        Logger.getTarget().log(3, tag, message, null);
    }

    public static void d(String tag, String message, Throwable throwable) {
        Logger.getTarget().log(3, tag, message, throwable);
    }

    public static void e(String tag, String message) {
        Logger.getTarget().log(6, tag, message, null);
    }

    public static void e(String tag, String message, Throwable throwable) {
        Logger.getTarget().log(6, tag, message, throwable);
    }

    public static void v(String tag, String message) {
        Logger.getTarget().log(2, tag, message, null);
    }

    public static void v(String tag, String message, Throwable throwable) {
        Logger.getTarget().log(2, tag, message, throwable);
    }

    public static void w(String tag, String message) {
        Logger.getTarget().log(5, tag, message, null);
    }

    public static void w(String tag, String message, Throwable throwable) {
        Logger.getTarget().log(5, tag, message, throwable);
    }

    public static void wtf(String tag, String message) {
        Logger.getTarget().log(7, tag, message, null);
    }

    public static void wtf(String tag, String message, Throwable throwable) {
        Logger.getTarget().log(7, tag, message, throwable);
    }

    static {
        Logger.setTarget(new LogcatTarget());
    }
}

