/*
 * Decompiled with CFR 0.152.
 */
package nl.geodienstencentrum.maven.plugin.sass.report;

import com.google.common.primitives.Ints;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import nl.geodienstencentrum.maven.plugin.sass.AbstractSassMojo;
import nl.geodienstencentrum.maven.plugin.sass.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="scss-lint", defaultPhase=LifecyclePhase.COMPILE, executionStrategy="once-per-session", threadSafe=true)
public class SCSSLintMojo
extends AbstractSassMojo {
    @Parameter(defaultValue="${project.build.directory}/scss-lint.xml", readonly=true)
    private File outputFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            return;
        }
        Log log = this.getLog();
        Set<String> sourceDirs = this.getSourceDirs();
        if (sourceDirs.isEmpty()) {
            return;
        }
        this.outputFile.getParentFile().mkdirs();
        log.info((CharSequence)("Linting Sass sources in: " + this.getSassSourceDirectory()));
        StringBuilder sassScript = new StringBuilder();
        this.buildBasicSassScript(sassScript);
        log.debug((CharSequence)("scss-lint ruby script:\n" + sassScript));
        System.setProperty("org.jruby.embed.localcontext.scope", "threadsafe");
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine jruby = scriptEngineManager.getEngineByName("jruby");
        ScriptContext context = jruby.getContext();
        ArrayList<String> argv = new ArrayList<String>();
        argv.add("--format=Checkstyle");
        argv.add("--no-color");
        argv.add("-o" + this.outputFile);
        argv.addAll(sourceDirs);
        context.setAttribute("javax.script.argv", argv.toArray(new String[argv.size()]), 200);
        try {
            log.info((CharSequence)("Reporting scss lint in: " + this.outputFile.getAbsolutePath()));
            ExitCode result = ExitCode.getExitCode(Ints.checkedCast((long)((Long)jruby.eval(sassScript.toString(), context))));
            log.debug((CharSequence)("scss-lint result: " + result.toString()));
            switch (result) {
                case CODE_0: {
                    log.info((CharSequence)result.msg());
                    break;
                }
                case CODE_1: {
                    log.warn((CharSequence)result.msg());
                    break;
                }
                case CODE_2: {
                    log.error((CharSequence)result.toString());
                    if (this.failOnError) {
                        throw new MojoFailureException(result.toString());
                    }
                    break;
                }
                default: {
                    log.error((CharSequence)result.toString());
                    throw new MojoExecutionException(result.toString());
                }
            }
        }
        catch (ScriptException e) {
            throw new MojoExecutionException("Failed to execute scss-lint Ruby script:\n" + sassScript, (Exception)e);
        }
    }

    @Override
    protected void buildBasicSassScript(StringBuilder sassScript) throws MojoExecutionException {
        Log log = this.getLog();
        sassScript.append("require 'scss_lint'\n");
        sassScript.append("require 'scss_lint/cli'\n");
        sassScript.append("require 'scss_lint_reporter_checkstyle'\n");
        if (log.isDebugEnabled()) {
            sassScript.append("require 'pp'\n");
            sassScript.append("puts 'parameters: '\n");
            sassScript.append("pp ARGV\n");
        }
        sassScript.append("logger = SCSSLint::Logger.new(STDOUT)\n");
        sassScript.append("SCSSLint::CLI.new(logger).run(ARGV)\n");
    }

    private Set<String> getSourceDirs() {
        HashSet<String> dirs = new HashSet<String>();
        List<Resource> resourceList = this.getResources();
        if (resourceList.isEmpty()) {
            dirs.add(this.getSassSourceDirectory().getPath());
        }
        for (Resource source : resourceList) {
            dirs.addAll(source.getDirectoriesAndDestinations(this.getLog()).keySet());
        }
        return dirs;
    }

    public static enum ExitCode {
        CODE_0(0, "No lints were found"),
        CODE_1(1, "Lints with a severity of 'warning' were reported (no errors)"),
        CODE_2(2, "One or more errors were reported (and any number of warnings)"),
        CODE_64(64, "Command line usage error (invalid flag, etc.)"),
        CODE_66(66, "Input file did not exist or was not readable"),
        CODE_70(70, "Internal software error"),
        CODE_78(78, "Configuration error");

        private static final HashMap<Integer, ExitCode> LOOKUP;
        private final String msg;
        private final int code;

        private ExitCode(int code, String msg) {
            this.code = code;
            this.msg = msg;
        }

        String msg() {
            return this.msg;
        }

        int code() {
            return this.code;
        }

        static ExitCode getExitCode(int code) {
            return LOOKUP.get(code);
        }

        public String toString() {
            return this.code + ": " + this.msg;
        }

        static {
            LOOKUP = new HashMap();
            for (ExitCode c : EnumSet.allOf(ExitCode.class)) {
                LOOKUP.put(c.code, c);
            }
        }
    }
}

