/*
 * Decompiled with CFR 0.152.
 */
package nl.lexemmens.podman;

import java.util.List;
import nl.lexemmens.podman.AbstractCatalogSupport;
import nl.lexemmens.podman.service.ServiceHub;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="push", defaultPhase=LifecyclePhase.DEPLOY)
public class PushMojo
extends AbstractCatalogSupport {
    @Parameter(defaultValue="false", property="podman.skip.push", required=true)
    boolean skipPush;
    @Parameter(property="podman.image.delete.after.push", defaultValue="false", required=true)
    boolean deleteLocalImageAfterPush;
    @Parameter(property="podman.push.retries", defaultValue="0", required=true)
    int retries;

    @Override
    public void executeInternal(ServiceHub hub) throws MojoExecutionException {
        this.checkAuthentication(hub);
        if (this.pushRegistry == null) {
            String msg = "Failed to push container images. No registry specified. Configure the registry by adding the <pushRegistry><!-- registry --></pushRegistry> tag to your configuration.";
            this.getLog().error((CharSequence)msg);
            throw new MojoExecutionException(msg);
        }
        this.getLog().info((CharSequence)"Using container-catalog.txt to perform podman push");
        List<String> cataloguedImages = this.readLocalCatalog();
        if (cataloguedImages.isEmpty()) {
            this.getLog().info((CharSequence)"Not pushing container images, because no container-catalog.txt file was found.");
        } else {
            this.pushContainerImages(hub, cataloguedImages);
            this.getLog().info((CharSequence)"All images have been successfully pushed to the registry");
        }
    }

    @Override
    protected boolean skipGoal() {
        return this.skipPush;
    }

    private void pushContainerImages(ServiceHub hub, List<String> images) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Pushing container images to registry ...");
        for (String fullImage : images) {
            this.pushImage(hub, fullImage);
        }
    }

    private void pushImage(ServiceHub hub, String fullImageName) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Pushing image: " + fullImageName + " to " + this.pushRegistry));
        for (int i = 0; i <= this.retries; ++i) {
            try {
                hub.getPodmanExecutorService().push(fullImageName);
                break;
            }
            catch (MojoExecutionException e) {
                if (i == this.retries) {
                    throw e;
                }
                this.getLog().warn((CharSequence)("Failed to push image " + fullImageName + ", retrying..."));
                continue;
            }
        }
        if (this.deleteLocalImageAfterPush) {
            this.getLog().info((CharSequence)("Removing image " + fullImageName + " from the local repository"));
            hub.getPodmanExecutorService().removeLocalImage(fullImageName);
        }
        this.getLog().info((CharSequence)("Successfully pushed container image " + fullImageName + " to " + this.pushRegistry));
    }
}

