/*
 * Decompiled with CFR 0.152.
 */
package nl.lexemmens.podman.command;

import java.io.File;
import java.io.OutputStream;
import java.util.List;
import nl.lexemmens.podman.command.Command;
import nl.lexemmens.podman.executor.CommandExecutorDelegate;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.stream.slf4j.Slf4jStream;

public abstract class AbstractCommand
implements Command {
    private static final File BASE_DIR = new File(".");
    protected final Log log;
    private final CommandExecutorDelegate delegate;
    private final File workDir;

    protected AbstractCommand(Log log, CommandExecutorDelegate delegate) {
        this(log, delegate, null);
    }

    protected AbstractCommand(Log log, CommandExecutorDelegate delegate, File workDir) {
        this.log = log;
        this.delegate = delegate;
        this.workDir = workDir == null ? BASE_DIR : workDir;
    }

    @Override
    public List<String> execute() throws MojoExecutionException {
        String msg = String.format("Executing command '%s' from basedir %s", StringUtils.join(this.getCommand(), (String)" "), BASE_DIR.getAbsolutePath());
        this.log.debug((CharSequence)msg);
        ProcessExecutor processExecutor = new ProcessExecutor().directory(this.workDir).command(this.getCommand()).readOutput(true).redirectOutput((OutputStream)Slf4jStream.of((String)this.getClass().getSimpleName()).asInfo()).redirectError((OutputStream)Slf4jStream.of((String)this.getClass().getSimpleName()).asError()).exitValueNormal();
        if (this.redirectError()) {
            processExecutor.redirectError((OutputStream)Slf4jStream.of((String)this.getClass().getSimpleName()).asError());
        }
        return this.delegate.executeCommand(processExecutor);
    }

    protected abstract List<String> getCommand();

    protected abstract boolean redirectError();
}

