/*
 * Decompiled with CFR 0.152.
 */
package nl.lexemmens.podman.command.podman;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import nl.lexemmens.podman.command.Command;
import nl.lexemmens.podman.command.podman.AbstractPodmanCommand;
import nl.lexemmens.podman.config.podman.PodmanConfiguration;
import nl.lexemmens.podman.executor.CommandExecutorDelegate;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;

public class PodmanBuildCommand
extends AbstractPodmanCommand {
    private static final String PODMAN_ARG_PREFIX = "podman.buildArg.";
    private static final String SQUASH_CMD = "--squash";
    private static final String SQUASH_ALL_CMD = "--squash-all";
    private static final String LAYERS_CMD = "--layers";
    private static final String BUILD_FORMAT_CMD = "--format";
    private static final String CONTAINERFILE_CMD = "--file";
    private static final String PULL_CMD = "--pull";
    private static final String PULL_ALWAYS_CMD = "--pull-always";
    private static final String NO_CACHE_CMD = "--no-cache";
    private static final String BUILD_ARG_CMD = "--build-arg";
    private static final String PLATFORM_CMD = "--platform";
    private static final String TARGET_STAGE_CMD = "--target";
    private static final String SUBCOMMAND = "build";

    private PodmanBuildCommand(Log log, PodmanConfiguration podmanConfig, CommandExecutorDelegate delegate) {
        super(log, podmanConfig, delegate, SUBCOMMAND, false);
    }

    public static class Builder {
        private final PodmanBuildCommand command;

        public Builder(Log log, PodmanConfiguration podmanConfig, CommandExecutorDelegate delegate) {
            this.command = new PodmanBuildCommand(log, podmanConfig, delegate);
        }

        public Builder setSquash() {
            this.command.withOption(PodmanBuildCommand.SQUASH_CMD, null);
            return this;
        }

        public Builder setSquashAll() {
            this.command.withOption(PodmanBuildCommand.SQUASH_ALL_CMD, null);
            return this;
        }

        public Builder setLayers(Boolean layers) {
            this.command.withOption(PodmanBuildCommand.LAYERS_CMD, layers.toString());
            return this;
        }

        public Builder setFormat(String format) {
            this.command.withOption(PodmanBuildCommand.BUILD_FORMAT_CMD, format);
            return this;
        }

        public Builder setContainerFile(Path containerFile) {
            this.command.withOption(PodmanBuildCommand.CONTAINERFILE_CMD, containerFile.toString());
            return this;
        }

        public Builder setPull(Boolean pull) {
            this.command.withOption(PodmanBuildCommand.PULL_CMD, pull.toString());
            return this;
        }

        public Builder setNoCache(boolean noCache) {
            this.command.withOption(PodmanBuildCommand.NO_CACHE_CMD, "" + noCache);
            return this;
        }

        public Builder setPullAllways(Boolean pullAlways) {
            this.command.withOption(PodmanBuildCommand.PULL_ALWAYS_CMD, pullAlways.toString());
            return this;
        }

        public Builder setPlatform(String platform) {
            this.command.withOption(PodmanBuildCommand.PLATFORM_CMD, platform);
            return this;
        }

        public Builder setTargetStage(String targetStage) {
            this.command.withOption(PodmanBuildCommand.TARGET_STAGE_CMD, targetStage);
            return this;
        }

        public Builder addBuildArgs(Map<String, String> args) {
            HashMap<String, String> allBuildArgs = new HashMap<String, String>(args);
            allBuildArgs.putAll(this.getBuildArgsFromSystem());
            for (Map.Entry arg : allBuildArgs.entrySet()) {
                this.command.withOption(PodmanBuildCommand.BUILD_ARG_CMD, String.format("%s=%s", arg.getKey(), arg.getValue()));
            }
            return this;
        }

        private Map<String, String> getBuildArgsFromSystem() {
            HashMap<String, String> buildArgsFromSystem = new HashMap<String, String>();
            Properties properties = System.getProperties();
            for (Object keyObj : properties.keySet()) {
                String key = (String)keyObj;
                if (!key.startsWith(PodmanBuildCommand.PODMAN_ARG_PREFIX)) continue;
                String argKey = key.replaceFirst(PodmanBuildCommand.PODMAN_ARG_PREFIX, "");
                String value = properties.getProperty(key);
                if (StringUtils.isEmpty((CharSequence)value)) continue;
                buildArgsFromSystem.put(argKey, value);
            }
            return buildArgsFromSystem;
        }

        public Command build() {
            this.command.withOption(".", null);
            return this.command;
        }
    }
}

