/*
 * Decompiled with CFR 0.152.
 */
package nl.lexemmens.podman.command.skopeo;

import java.util.ArrayList;
import java.util.List;
import nl.lexemmens.podman.command.AbstractCommand;
import nl.lexemmens.podman.command.Command;
import nl.lexemmens.podman.config.skopeo.SkopeoConfiguration;
import nl.lexemmens.podman.executor.CommandExecutorDelegate;
import org.apache.maven.plugin.logging.Log;

public class SkopeoCopyCommand
extends AbstractCommand {
    private static final String SRC_TLS_VERIFY_CMD = "--src-tls-verify";
    private static final String DEST_TLS_VERIFY_CMD = "--dest-tls-verify";
    private static final String IMAGE_PREFIX = "docker://";
    private static final String BASE_COMMAND = "skopeo";
    private final List<String> command = new ArrayList<String>();

    private SkopeoCopyCommand(Log log, SkopeoConfiguration skopeoConfig, CommandExecutorDelegate delegate) {
        super(log, delegate);
        this.command.add(BASE_COMMAND);
        this.withOption("copy", null);
        this.withOption(SRC_TLS_VERIFY_CMD, "" + skopeoConfig.getCopy().getSrcTlsVerify());
        this.withOption(DEST_TLS_VERIFY_CMD, "" + skopeoConfig.getCopy().getDestTlsVerify());
    }

    @Override
    protected List<String> getCommand() {
        return this.command;
    }

    @Override
    protected boolean redirectError() {
        return false;
    }

    private void withOption(String option, String optionValue) {
        String subCommand = optionValue == null ? option : String.format("%s=%s", option, optionValue);
        this.command.add(subCommand);
    }

    public static class Builder {
        private final SkopeoCopyCommand command;

        public Builder(Log log, SkopeoConfiguration skopeoConfig, CommandExecutorDelegate delegate) {
            this.command = new SkopeoCopyCommand(log, skopeoConfig, delegate);
        }

        public Builder setSourceImage(String fullImageName) {
            this.setImage(fullImageName);
            return this;
        }

        public Builder setDestinationImage(String fullImageName) {
            this.setImage(fullImageName);
            return this;
        }

        private void setImage(String fullImageName) {
            this.command.withOption(SkopeoCopyCommand.IMAGE_PREFIX + fullImageName, null);
        }

        public Command build() {
            return this.command;
        }
    }
}

