/*
 * Decompiled with CFR 0.152.
 */
package nl.lexemmens.podman.config.image.batch;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import nl.lexemmens.podman.config.image.AbstractImageConfiguration;
import nl.lexemmens.podman.config.image.StageConfiguration;
import nl.lexemmens.podman.config.image.batch.BatchImageBuildConfiguration;
import nl.lexemmens.podman.config.image.single.SingleImageBuildConfiguration;
import nl.lexemmens.podman.config.image.single.SingleImageConfiguration;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public class BatchImageConfiguration
extends AbstractImageConfiguration<BatchImageBuildConfiguration> {
    @Parameter
    protected BatchImageBuildConfiguration build;

    public void initAndValidate(Log log, MavenProject project) throws MojoExecutionException {
        super.initAndValidate(log);
        if (this.build == null) {
            throw new MojoExecutionException("Missing <build/> section in batch image configuration!");
        }
        this.build.validate(project);
    }

    public List<SingleImageConfiguration> resolve(Log log) throws MojoExecutionException {
        List<Path> allContainerFiles = this.getBuild().getAllContainerFiles();
        if (allContainerFiles == null || allContainerFiles.isEmpty()) {
            throw new MojoExecutionException("Invalid batch configuration found!");
        }
        return this.convertToSingleImageConfigurations(log, allContainerFiles);
    }

    private List<SingleImageConfiguration> convertToSingleImageConfigurations(Log log, List<Path> allContainerFiles) throws MojoExecutionException {
        ArrayList<SingleImageConfiguration> imageConfigurations = new ArrayList<SingleImageConfiguration>();
        log.info((CharSequence)("[BATCH] Found " + allContainerFiles.size() + " Containerfiles"));
        for (Path containerFile : this.getBuild().getAllContainerFiles()) {
            SingleImageConfiguration imageConfiguration = new SingleImageConfiguration();
            imageConfiguration.setImageName(this.getImageName());
            imageConfiguration.setCustomImageNameForMultiStageContainerfile(this.useCustomImageNameForMultiStageContainerfile());
            imageConfiguration.setStages(this.convertStages(this.getStages()));
            SingleImageBuildConfiguration buildConfiguration = new SingleImageBuildConfiguration();
            buildConfiguration.setContainerFile(containerFile.getFileName().toString());
            buildConfiguration.setContainerFileDir(containerFile.getParent().toFile());
            buildConfiguration.setFormat(this.getBuild().getFormat());
            buildConfiguration.setCreateLatestTag(this.getBuild().isCreateLatestTag());
            buildConfiguration.setLabels(this.getBuild().getLabels());
            if (this.getBuild().getPull().isPresent()) {
                buildConfiguration.setPull(this.getBuild().getPull().get());
            }
            buildConfiguration.setNoCache(this.getBuild().isNoCache());
            buildConfiguration.setTags(this.getBuild().getTags());
            if (this.getBuild().getPullAlways().isPresent()) {
                buildConfiguration.setPullAlways(this.getBuild().getPullAlways().get());
            }
            buildConfiguration.setTagWithMavenProjectVersion(this.getBuild().isTagWithMavenProjectVersion());
            imageConfiguration.setBuild(buildConfiguration);
            imageConfigurations.add(imageConfiguration);
        }
        return imageConfigurations;
    }

    private StageConfiguration[] convertStages(StageConfiguration[] stages) {
        StageConfiguration[] convertedStages = null;
        if (stages != null) {
            convertedStages = new StageConfiguration[stages.length];
            for (int i = 0; i < stages.length; ++i) {
                StageConfiguration convertedStage = new StageConfiguration();
                convertedStage.setName(stages[i].getName());
                convertedStage.setImageName(stages[i].getImageName());
                convertedStages[i] = convertedStage;
            }
        }
        return convertedStages;
    }

    @Override
    public BatchImageBuildConfiguration getBuild() {
        return this.build;
    }
}

