/*
 * Decompiled with CFR 0.152.
 */
package nl.lexemmens.podman.helper;

import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.lexemmens.podman.config.image.single.SingleImageConfiguration;
import org.apache.maven.plugin.logging.Log;

public final class MultiStageBuildOutputHelper {
    private static final Pattern IMAGE_HASH_PATTERN = Pattern.compile("\\b([A-Fa-f0-9]{11,64})\\b");

    public void recordImageHashes(Log log, SingleImageConfiguration image, List<String> processOutput) {
        Pattern stagePattern = image.getBuild().getMultistageContainerfilePattern();
        log.debug((CharSequence)("Using regular expression: " + stagePattern));
        int lastLine = processOutput.size() - 2;
        int searchIndex = 0;
        while (searchIndex <= lastLine) {
            String currentLine = processOutput.get(searchIndex);
            String currentStage = MultiStageBuildOutputHelper.getCurrentStage(log, stagePattern, currentLine);
            if (currentStage == null) {
                ++searchIndex;
                continue;
            }
            ImageHashSearchResult imageHashSearchResult = MultiStageBuildOutputHelper.findImageHash(log, processOutput, searchIndex + 1, stagePattern);
            MultiStageBuildOutputHelper.recordImageHash(log, image, currentStage, imageHashSearchResult);
            if (imageHashSearchResult.isLastLine) break;
            searchIndex = imageHashSearchResult.nextIndex;
        }
        log.debug((CharSequence)("Collected hashes: " + image.getImageHashPerStage()));
    }

    private static void recordImageHash(Log log, SingleImageConfiguration image, String currentStage, ImageHashSearchResult imageHashSearchResult) {
        if (imageHashSearchResult.imageHash == null) {
            log.warn((CharSequence)("No image hash found for stage: '" + currentStage + "'"));
        } else {
            log.info((CharSequence)("Final image for stage " + currentStage + " is: " + imageHashSearchResult.imageHash));
            image.getImageHashPerStage().put(currentStage, imageHashSearchResult.imageHash);
        }
    }

    private static String getCurrentStage(Log log, Pattern stagePattern, String currentLine) {
        String currentStage = null;
        Matcher stageMatcher = stagePattern.matcher(currentLine);
        boolean currentLineDefinesStage = stageMatcher.find();
        log.debug((CharSequence)("Processing line: '" + currentLine + "'"));
        if (currentLineDefinesStage) {
            currentStage = stageMatcher.group(3);
            log.debug((CharSequence)("Processing stage in Containerfile: " + currentStage));
        }
        return currentStage;
    }

    private static ImageHashSearchResult findImageHash(Log log, List<String> processOutput, int searchStartIndex, Pattern multiStagePattern) {
        ImageHashSearchResult searchResult = ImageHashSearchResult.EMPTY;
        String lastKnownImageHash = null;
        int lastLine = processOutput.size() - 2;
        for (int idx = searchStartIndex; idx <= lastLine; ++idx) {
            boolean isLastLine = idx == lastLine;
            String candidate = processOutput.get(idx);
            log.debug((CharSequence)("Processing candidate: '" + candidate + "'"));
            Matcher nextStageMatcher = multiStagePattern.matcher(candidate);
            boolean candidateLineDefinesStage = nextStageMatcher.find();
            Optional<String> imageHashOptional = MultiStageBuildOutputHelper.retrieveImageHashFromLine(candidate);
            if (!candidateLineDefinesStage && imageHashOptional.isPresent()) {
                lastKnownImageHash = imageHashOptional.get();
                log.debug((CharSequence)("Derived hash: '" + lastKnownImageHash + "' from:     " + candidate));
            }
            if (candidateLineDefinesStage || isLastLine) {
                searchResult = new ImageHashSearchResult(lastKnownImageHash, idx, isLastLine);
                break;
            }
            log.debug((CharSequence)("No stage or image hash on line: " + candidate));
        }
        return searchResult;
    }

    private static Optional<String> retrieveImageHashFromLine(String line) {
        String imageHash = null;
        Matcher matcher = IMAGE_HASH_PATTERN.matcher(line);
        if (matcher.find()) {
            imageHash = matcher.group(1);
        }
        return Optional.ofNullable(imageHash);
    }

    private static class ImageHashSearchResult {
        private static final ImageHashSearchResult EMPTY = new ImageHashSearchResult(null, -1, true);
        private final String imageHash;
        private final int nextIndex;
        private final boolean isLastLine;

        public ImageHashSearchResult(String imageHash, int nextIndex, boolean isLastLine) {
            this.imageHash = imageHash;
            this.nextIndex = nextIndex;
            this.isLastLine = isLastLine;
        }
    }
}

