/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.html;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import nl.talsmasoftware.umldoclet.configuration.Configuration;
import nl.talsmasoftware.umldoclet.html.DiagramFile;
import nl.talsmasoftware.umldoclet.html.Postprocessor;
import nl.talsmasoftware.umldoclet.logging.Message;

final class HtmlFile {
    final Configuration config;
    final Path path;

    HtmlFile(Configuration config, Path path) {
        this.config = Objects.requireNonNull(config, "Configuration is <null>.");
        this.path = Objects.requireNonNull(path, "HTML file is <null>.").normalize();
    }

    static boolean isHtmlFile(Path path) {
        File file = path == null ? null : path.toFile();
        return file != null && file.isFile() && file.canRead() && file.getName().endsWith(".html");
    }

    boolean process(Collection<DiagramFile> diagrams) {
        return diagrams.stream().filter(diagram -> diagram.matches(this)).map(diagram -> new Postprocessor(this, (DiagramFile)diagram)).map(this::process).reduce(Boolean.FALSE, Boolean::logicalOr) != false || this.skip();
    }

    private boolean skip() {
        this.config.logger().debug((Object)Message.DEBUG_SKIPPING_FILE, this.path);
        return false;
    }

    private boolean process(Postprocessor postprocessor) {
        try {
            if (postprocessor.call().booleanValue()) {
                this.config.logger().info(Message.INFO_ADD_DIAGRAM_TO_FILE, this.path);
                return true;
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException("I/O exception postprocessing " + String.valueOf(this.path), ioe);
        }
        return false;
    }

    public List<String> readLines() throws IOException {
        return Files.readAllLines(this.path, this.config.htmlCharset());
    }

    File createNewTempFile() throws IOException {
        String fileName = this.path.getFileName().toString();
        int lastDot = fileName.lastIndexOf(46);
        Object prefix = fileName;
        String suffix = null;
        if (lastDot > 0) {
            prefix = fileName.substring(0, lastDot);
            suffix = fileName.substring(lastDot);
        }
        prefix = (String)prefix + "---".substring(0, Math.max(1, 3 - ((String)prefix).length()));
        return File.createTempFile((String)prefix, suffix);
    }

    public void replaceBy(File tempFile) throws IOException {
        if (tempFile != null && tempFile.isFile()) {
            Files.move(tempFile.toPath(), this.path, StandardCopyOption.REPLACE_EXISTING);
            this.config.logger().debug((Object)Message.DEBUG_REPLACING_BY, this.path, tempFile);
        }
    }
}

