/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.rendering.indent;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Objects;
import nl.talsmasoftware.umldoclet.rendering.indent.Indentation;
import nl.talsmasoftware.umldoclet.rendering.indent.IndentingWriter;

public class IndentingPrintWriter
extends PrintWriter {
    protected IndentingPrintWriter(Appendable writer, Indentation indentation) {
        super(IndentingWriter.wrap(writer, indentation));
    }

    public static IndentingPrintWriter wrap(Appendable delegate, Indentation indentation) {
        return delegate instanceof IndentingPrintWriter ? ((IndentingPrintWriter)delegate).withIndentation(indentation) : new IndentingPrintWriter(delegate, indentation);
    }

    protected IndentingWriter getDelegate() {
        return (IndentingWriter)this.out;
    }

    private Indentation getIndentation() {
        return Objects.requireNonNull(this.out instanceof IndentingWriter ? ((IndentingWriter)this.out).getIndentation() : null, "No indentation detected in IndentingPrintWriter!");
    }

    private IndentingPrintWriter withIndentation(Indentation indentation) {
        return indentation == null || indentation.equals(this.getIndentation()) ? this : new IndentingPrintWriter((Appendable)this.out, indentation);
    }

    public IndentingPrintWriter indent() {
        return this.withIndentation(this.getIndentation().increase());
    }

    public IndentingPrintWriter unindent() {
        return this.withIndentation(this.getIndentation().decrease());
    }

    public IndentingPrintWriter whitespace() {
        try {
            if (this.out instanceof IndentingWriter) {
                ((IndentingWriter)this.out).whitespace();
            } else {
                this.out.append(' ');
            }
            return this;
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Error writing whitespace: " + ioe.getMessage(), ioe);
        }
    }

    public IndentingPrintWriter newline() {
        super.println();
        return this;
    }

    @Override
    public IndentingPrintWriter append(CharSequence csq) {
        return (IndentingPrintWriter)super.append(csq);
    }

    @Override
    public IndentingPrintWriter append(CharSequence csq, int start, int end) {
        return (IndentingPrintWriter)super.append(csq, start, end);
    }

    @Override
    public IndentingPrintWriter append(char c) {
        return (IndentingPrintWriter)super.append(c);
    }

    public String toString() {
        return this.out.toString();
    }
}

