/*
 * Decompiled with CFR 0.152.
 */
package no.maddin.niofs.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.UserInfo;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import no.maddin.niofs.sftp.SFTPHost;
import no.maddin.niofs.sftp.SFTPPath;
import no.maddin.niofs.sftp.SFTPUserInfo;

public class SFTPFileSystemProvider
extends FileSystemProvider {
    private static final String SFTP = "sftp";
    private static final int DEFAULT_PORT = 22;
    private final Map<URI, SFTPHost> hosts = new HashMap<URI, SFTPHost>();
    private JSch jsch = new JSch();

    public SFTPFileSystemProvider() {
        JSch.setConfig((String)"StrictHostKeyChecking", (String)"no");
    }

    @Override
    public String getScheme() {
        return SFTP;
    }

    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        try {
            return this.getSFTPHost(uri, true);
        }
        catch (URISyntaxException e) {
            throw new FileSystemException(e.toString());
        }
    }

    @Override
    public FileSystem getFileSystem(URI uri) {
        try {
            return this.getSFTPHost(uri, true);
        }
        catch (URISyntaxException ex) {
            throw new FileSystemNotFoundException(uri.toString());
        }
    }

    @Override
    public Path getPath(URI uri) {
        try {
            SFTPHost host = this.getSFTPHost(uri, true);
            return new SFTPPath(host, uri.getPath());
        }
        catch (URISyntaxException e) {
            throw new FileSystemNotFoundException(uri.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SFTPHost getSFTPHost(URI uri, boolean create) throws URISyntaxException {
        String host = uri.getHost();
        if (host == null) {
            throw new IllegalArgumentException(uri.toString());
        }
        int port = uri.getPort();
        if (port == -1) {
            port = 22;
        }
        String userInfo = uri.getUserInfo();
        URI serverUri = new URI(this.getScheme(), userInfo, host, port, null, null, null);
        Map<URI, SFTPHost> map = this.hosts;
        synchronized (map) {
            SFTPHost fs = this.hosts.get(serverUri);
            if (fs == null && create) {
                fs = new SFTPHost(this, serverUri);
                this.hosts.put(serverUri, fs);
            }
            return fs;
        }
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        if (!(dir instanceof SFTPPath)) {
            throw new IllegalArgumentException(dir.toString());
        }
        SFTPHost sftpHost = (SFTPHost)dir.getFileSystem();
        String username = sftpHost.getUserName();
        String host = sftpHost.getHost();
        int port = sftpHost.getPort();
        try {
            Session session = this.jsch.getSession(username, host, port);
            SFTPUserInfo userinfo = new SFTPUserInfo(sftpHost.getPassword());
            session.setUserInfo((UserInfo)userinfo);
            session.connect();
            ChannelSftp sftp = (ChannelSftp)session.openChannel(SFTP);
            sftp.connect();
            List<String> parts = ((SFTPPath)dir).getParts();
            if (!parts.isEmpty() && "".equals(parts.get(0))) {
                parts = parts.subList(1, parts.size() - 1);
            }
            for (String subPath : parts) {
                try {
                    sftp.mkdir(subPath);
                }
                catch (SftpException e) {
                    throw new IOException(subPath, e);
                }
            }
            sftp.quit();
            session.disconnect();
        }
        catch (JSchException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void delete(Path path) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSameFile(Path path, Path path2) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }
}

