/* Copyright 2004, 2005 Acegi Technology Pty Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.acegisecurity.context;

import org.acegisecurity.Authentication;


/**
 * Base implementation of {@link SecurityContext}.
 *
 * <p>
 * Used by default by {@link SecurityContextHolder} and {@link HttpSessionContextIntegrationFilter}.
 * </p>
 *
 * @author Ben Alex
 * @version $Id: SecurityContextImpl.java,v 1.4 2005/11/17 00:55:49 benalex Exp $
 */
public class SecurityContextImpl implements SecurityContext {
    private Authentication authentication;

    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public Authentication getAuthentication() {
        return authentication;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SecurityContextImpl) {
            SecurityContextImpl test = (SecurityContextImpl) obj;

            if ((this.getAuthentication() == null) &&
                    (test.getAuthentication() == null)) {
                return true;
            }

            if ((this.getAuthentication() != null) &&
                    (test.getAuthentication() != null) &&
                    this.getAuthentication().equals(test.getAuthentication())) {
                return true;
            }
        }

        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());

        if (this.authentication == null) {
            sb.append(": Null authentication");
        } else {
            sb.append(": Authentication: " + this.authentication);
        }

        return sb.toString();
    }

    public int hashCode() {
        if (this.authentication == null) {
            return -1;
        } else {
            return this.authentication.hashCode();
        }
    }
}
