/* Copyright 2004, 2005 Acegi Technology Pty Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.acegisecurity.providers.ldap;

import javax.naming.directory.DirContext;

/**
 * Access point for obtaining LDAP contexts.
 *
 * @see DefaultInitialDirContextFactory
 *
 * @author Luke Taylor
 * @version $Id: InitialDirContextFactory.java,v 1.2 2005/12/24 10:03:18 benalex Exp $
 */
public interface InitialDirContextFactory {

    /**
     * Provides an initial context without specific user information.
     */
    DirContext newInitialDirContext();

    /**
     * Provides an initial context by binding as a specific user.
     */
    DirContext newInitialDirContext(String userDn, String password);

    /**
     * @return The DN of the contexts returned by this factory.
     */
    String getRootDn();
}
