/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.ldap;

import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationServiceException;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.dao.AbstractUserDetailsAuthenticationProvider;
import org.acegisecurity.providers.ldap.LdapAuthenticator;
import org.acegisecurity.providers.ldap.LdapAuthoritiesPopulator;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.ldap.LdapUserDetails;
import org.acegisecurity.userdetails.ldap.LdapUserDetailsImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class LdapAuthenticationProvider
extends AbstractUserDetailsAuthenticationProvider {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$providers$ldap$LdapAuthenticationProvider == null ? (class$org$acegisecurity$providers$ldap$LdapAuthenticationProvider = LdapAuthenticationProvider.class$("org.acegisecurity.providers.ldap.LdapAuthenticationProvider")) : class$org$acegisecurity$providers$ldap$LdapAuthenticationProvider));
    private LdapAuthenticator authenticator;
    private LdapAuthoritiesPopulator authoritiesPopulator;
    static /* synthetic */ Class class$org$acegisecurity$providers$ldap$LdapAuthenticationProvider;

    public LdapAuthenticationProvider(LdapAuthenticator authenticator, LdapAuthoritiesPopulator authoritiesPopulator) {
        this.setAuthenticator(authenticator);
        this.setAuthoritiesPopulator(authoritiesPopulator);
    }

    private void setAuthenticator(LdapAuthenticator authenticator) {
        Assert.notNull((Object)authenticator, (String)"An LdapAuthenticator must be supplied");
        this.authenticator = authenticator;
    }

    private LdapAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    private void setAuthoritiesPopulator(LdapAuthoritiesPopulator authoritiesPopulator) {
        Assert.notNull((Object)authoritiesPopulator, (String)"An LdapAuthoritiesPopulator must be supplied");
        this.authoritiesPopulator = authoritiesPopulator;
    }

    protected LdapAuthoritiesPopulator getAuthoritiesPopulator() {
        return this.authoritiesPopulator;
    }

    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        if (!userDetails.getPassword().equals(authentication.getCredentials().toString())) {
            throw new BadCredentialsException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.badCredentials", "Bad credentials"), userDetails);
        }
    }

    protected UserDetails createUserDetails(LdapUserDetails ldapUser, String username, String password) {
        LdapUserDetailsImpl.Essence user = new LdapUserDetailsImpl.Essence(ldapUser);
        user.setUsername(username);
        user.setPassword(password);
        GrantedAuthority[] extraAuthorities = this.getAuthoritiesPopulator().getGrantedAuthorities(ldapUser);
        for (int i = 0; i < extraAuthorities.length; ++i) {
            user.addAuthority(extraAuthorities[i]);
        }
        return user.createUserDetails();
    }

    protected UserDetails retrieveUser(String username, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        if (!StringUtils.hasLength((String)username)) {
            throw new BadCredentialsException(this.messages.getMessage("LdapAuthenticationProvider.emptyUsername", "Empty Username"));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Retrieving user " + username));
        }
        String password = (String)authentication.getCredentials();
        Assert.notNull((Object)password, (String)"Null password was supplied in authentication token");
        if (password.length() == 0) {
            logger.debug((Object)("Rejecting empty password for user " + username));
            throw new BadCredentialsException(this.messages.getMessage("LdapAuthenticationProvider.emptyPassword", "Empty Password"));
        }
        try {
            LdapUserDetails ldapUser = this.getAuthenticator().authenticate(username, password);
            return this.createUserDetails(ldapUser, username, password);
        }
        catch (DataAccessException ldapAccessFailure) {
            throw new AuthenticationServiceException(ldapAccessFailure.getMessage(), ldapAccessFailure);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

