/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.SubProcess;

public abstract class FlowNode
extends FlowElement {
    protected SubProcess subProcess;
    protected boolean asynchronous;
    protected boolean notExclusive;
    protected List<SequenceFlow> incomingFlows = new ArrayList<SequenceFlow>();
    protected List<SequenceFlow> outgoingFlows = new ArrayList<SequenceFlow>();
    @JsonIgnore
    protected Object behavior;

    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    public void setAsynchronous(boolean asynchronous) {
        this.asynchronous = asynchronous;
    }

    public boolean isExclusive() {
        return !this.notExclusive;
    }

    public void setExclusive(boolean exclusive) {
        this.notExclusive = !exclusive;
    }

    public boolean isNotExclusive() {
        return this.notExclusive;
    }

    public void setNotExclusive(boolean notExclusive) {
        this.notExclusive = notExclusive;
    }

    public Object getBehavior() {
        return this.behavior;
    }

    public void setBehavior(Object behavior) {
        this.behavior = behavior;
    }

    public SubProcess getSubProcess() {
        return this.subProcess;
    }

    public void setSubProcess(SubProcess subProcess) {
        this.subProcess = subProcess;
    }

    public List<SequenceFlow> getIncomingFlows() {
        return this.incomingFlows;
    }

    public void setIncomingFlows(List<SequenceFlow> incomingFlows) {
        this.incomingFlows = incomingFlows;
    }

    public List<SequenceFlow> getOutgoingFlows() {
        return this.outgoingFlows;
    }

    public void setOutgoingFlows(List<SequenceFlow> outgoingFlows) {
        this.outgoingFlows = outgoingFlows;
    }

    public void setValues(FlowNode otherNode) {
        super.setValues(otherNode);
        this.setAsynchronous(otherNode.isAsynchronous());
        this.setNotExclusive(otherNode.isNotExclusive());
    }
}

