/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.jobexecutor;

import java.util.List;
import org.activiti.engine.impl.cmd.ExecuteJobsCmd;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.impl.jobexecutor.JobExecutor;
import org.activiti.engine.impl.jobexecutor.MultipleJobsExecutorContext;
import org.activiti.engine.impl.jobexecutor.SingleJobExecutorContext;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteJobsRunnable
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(ExecuteJobsRunnable.class);
    private JobEntity job;
    private List<String> jobIds;
    private JobExecutor jobExecutor;

    public ExecuteJobsRunnable(JobExecutor jobExecutor, JobEntity job) {
        this.jobExecutor = jobExecutor;
        this.job = job;
    }

    public ExecuteJobsRunnable(JobExecutor jobExecutor, List<String> jobIds) {
        this.jobExecutor = jobExecutor;
        this.jobIds = jobIds;
    }

    @Override
    public void run() {
        if (this.jobIds != null) {
            this.handleMultipleJobs();
        }
        if (this.job != null) {
            this.handleSingleJob();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleSingleJob() {
        SingleJobExecutorContext jobExecutorContext = new SingleJobExecutorContext();
        List<JobEntity> currentProcessorJobQueue = jobExecutorContext.getCurrentProcessorJobQueue();
        CommandExecutor commandExecutor = this.jobExecutor.getCommandExecutor();
        currentProcessorJobQueue.add(this.job);
        Context.setJobExecutorContext(jobExecutorContext);
        try {
            while (!currentProcessorJobQueue.isEmpty()) {
                JobEntity currentJob = currentProcessorJobQueue.remove(0);
                try {
                    commandExecutor.execute(new ExecuteJobsCmd(currentJob));
                }
                catch (Throwable e) {
                    log.error("exception during job execution: {}", (Object)e.getMessage(), (Object)e);
                }
                finally {
                    this.jobExecutor.jobDone(currentJob);
                }
            }
        }
        finally {
            Context.removeJobExecutorContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleMultipleJobs() {
        MultipleJobsExecutorContext jobExecutorContext = new MultipleJobsExecutorContext();
        List<String> currentProcessorJobQueue = jobExecutorContext.getCurrentProcessorJobQueue();
        CommandExecutor commandExecutor = this.jobExecutor.getCommandExecutor();
        currentProcessorJobQueue.addAll(this.jobIds);
        Context.setJobExecutorContext(jobExecutorContext);
        try {
            while (!currentProcessorJobQueue.isEmpty()) {
                String currentJobId = currentProcessorJobQueue.remove(0);
                try {
                    commandExecutor.execute(new ExecuteJobsCmd(currentJobId));
                }
                catch (Throwable e) {
                    log.error("exception during job execution: {}", (Object)e.getMessage(), (Object)e);
                }
                finally {
                    this.jobExecutor.jobDone(currentJobId);
                }
            }
        }
        finally {
            Context.removeJobExecutorContext();
        }
    }
}

