/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.List;
import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.TaskQueryImpl;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.persistence.CountingExecutionEntity;
import org.activiti.engine.impl.persistence.entity.AbstractEntityManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntityManager;
import org.activiti.engine.impl.persistence.entity.data.DataManager;
import org.activiti.engine.impl.persistence.entity.data.TaskDataManager;
import org.activiti.engine.task.Task;

public class TaskEntityManagerImpl
extends AbstractEntityManager<TaskEntity>
implements TaskEntityManager {
    protected TaskDataManager taskDataManager;

    public TaskEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration, TaskDataManager taskDataManager) {
        super(processEngineConfiguration);
        this.taskDataManager = taskDataManager;
    }

    @Override
    protected DataManager<TaskEntity> getDataManager() {
        return this.taskDataManager;
    }

    @Override
    public TaskEntity create() {
        TaskEntity taskEntity = (TaskEntity)super.create();
        taskEntity.setCreateTime(this.getClock().getCurrentTime());
        return taskEntity;
    }

    @Override
    public void insert(TaskEntity taskEntity, boolean fireCreateEvent) {
        if (taskEntity.getOwner() != null) {
            this.addOwnerIdentityLink(taskEntity, taskEntity.getOwner());
        }
        if (taskEntity.getAssignee() != null) {
            this.addAssigneeIdentityLinks(taskEntity);
        }
        super.insert(taskEntity, fireCreateEvent);
    }

    @Override
    public void insert(TaskEntity taskEntity, ExecutionEntity execution) {
        if (execution != null && execution.getTenantId() != null) {
            taskEntity.setTenantId(execution.getTenantId());
        }
        if (execution != null) {
            execution.getTasks().add(taskEntity);
            taskEntity.setExecutionId(execution.getId());
            taskEntity.setProcessInstanceId(execution.getProcessInstanceId());
            taskEntity.setProcessDefinitionId(execution.getProcessDefinitionId());
            this.getHistoryManager().recordTaskExecutionIdChange(taskEntity.getId(), taskEntity.getExecutionId());
        }
        this.insert(taskEntity, true);
        if (execution != null && this.isExecutionRelatedEntityCountEnabled(execution)) {
            CountingExecutionEntity countingExecutionEntity = (CountingExecutionEntity)((Object)execution);
            countingExecutionEntity.setTaskCount(countingExecutionEntity.getTaskCount() + 1);
        }
        this.getHistoryManager().recordTaskCreated(taskEntity, execution);
        this.getHistoryManager().recordTaskId(taskEntity);
        if (taskEntity.getFormKey() != null) {
            this.getHistoryManager().recordTaskFormKeyChange(taskEntity.getId(), taskEntity.getFormKey());
        }
    }

    @Override
    public void changeTaskAssignee(TaskEntity taskEntity, String assignee) {
        this.changeTaskAssignee(taskEntity, assignee, true);
    }

    @Override
    public void changeTaskAssigneeNoEvents(TaskEntity taskEntity, String assignee) {
        this.changeTaskAssignee(taskEntity, assignee, false);
    }

    private void changeTaskAssignee(TaskEntity taskEntity, String assignee, boolean fireEvents) {
        if (taskEntity.getAssignee() != null && !taskEntity.getAssignee().equals(assignee) || taskEntity.getAssignee() == null && assignee != null) {
            taskEntity.setAssignee(assignee);
            if (fireEvents) {
                this.fireAssignmentEvents(taskEntity);
            } else {
                this.recordTaskAssignment(taskEntity);
            }
            if (taskEntity.getId() != null) {
                this.getHistoryManager().recordTaskAssigneeChange(taskEntity.getId(), taskEntity.getAssignee());
                this.addAssigneeIdentityLinks(taskEntity);
                this.update(taskEntity, fireEvents);
            }
        }
    }

    @Override
    public void changeTaskOwner(TaskEntity taskEntity, String owner) {
        if (taskEntity.getOwner() != null && !taskEntity.getOwner().equals(owner) || taskEntity.getOwner() == null && owner != null) {
            taskEntity.setOwner(owner);
            if (taskEntity.getId() != null) {
                this.getHistoryManager().recordTaskOwnerChange(taskEntity.getId(), taskEntity.getOwner());
                this.addOwnerIdentityLink(taskEntity, taskEntity.getOwner());
                this.update(taskEntity);
            }
        }
    }

    protected void fireAssignmentEvents(TaskEntity taskEntity) {
        this.recordTaskAssignment(taskEntity);
        if (this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.TASK_ASSIGNED, taskEntity));
        }
    }

    protected void recordTaskAssignment(TaskEntity taskEntity) {
        this.getProcessEngineConfiguration().getListenerNotificationHelper().executeTaskListeners(taskEntity, "assignment");
        this.getHistoryManager().recordTaskAssignment(taskEntity);
    }

    private void addAssigneeIdentityLinks(TaskEntity taskEntity) {
        if (taskEntity.getAssignee() != null && taskEntity.getProcessInstance() != null) {
            this.getIdentityLinkEntityManager().involveUser(taskEntity.getProcessInstance(), taskEntity.getAssignee(), "participant");
        }
    }

    protected void addOwnerIdentityLink(TaskEntity taskEntity, String owner) {
        if (owner == null && taskEntity.getOwner() == null) {
            return;
        }
        if (owner != null && taskEntity.getProcessInstanceId() != null) {
            this.getIdentityLinkEntityManager().involveUser(taskEntity.getProcessInstance(), owner, "participant");
        }
    }

    @Override
    public void deleteTasksByProcessInstanceId(String processInstanceId, String deleteReason, boolean cascade) {
        List<TaskEntity> tasks = this.findTasksByProcessInstanceId(processInstanceId);
        for (TaskEntity task : tasks) {
            if (this.getEventDispatcher().isEnabled() && !task.isCanceled()) {
                task.setCanceled(true);
                this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createActivityCancelledEvent(task.getExecution().getActivityId(), task.getName(), task.getExecutionId(), task.getProcessInstanceId(), task.getProcessDefinitionId(), "userTask", deleteReason));
            }
            this.deleteTask(task, deleteReason, cascade, false);
        }
    }

    @Override
    public void deleteTask(TaskEntity task, String deleteReason, boolean cascade, boolean cancel) {
        if (!task.isDeleted()) {
            this.getProcessEngineConfiguration().getListenerNotificationHelper().executeTaskListeners(task, "delete");
            task.setDeleted(true);
            String taskId = task.getId();
            List<Task> subTasks = this.findTasksByParentTaskId(taskId);
            for (Task subTask : subTasks) {
                this.deleteTask((TaskEntity)subTask, deleteReason, cascade, cancel);
            }
            this.getIdentityLinkEntityManager().deleteIdentityLinksByTaskId(taskId);
            this.getVariableInstanceEntityManager().deleteVariableInstanceByTask(task);
            if (cascade) {
                this.getHistoricTaskInstanceEntityManager().delete(taskId);
            } else {
                this.getHistoryManager().recordTaskEnd(taskId, deleteReason);
            }
            this.delete(task, false);
            if (this.getEventDispatcher().isEnabled()) {
                if (cancel && !task.isCanceled()) {
                    task.setCanceled(true);
                    this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createActivityCancelledEvent(task.getExecution() != null ? task.getExecution().getActivityId() : null, task.getName(), task.getExecutionId() != null ? task.getExecutionId() : task.getId(), task.getProcessInstanceId(), task.getProcessDefinitionId(), "userTask", deleteReason));
                }
                this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_DELETED, task));
            }
        }
    }

    @Override
    public void delete(TaskEntity entity, boolean fireDeleteEvent) {
        CountingExecutionEntity countingExecutionEntity;
        super.delete(entity, fireDeleteEvent);
        if (entity.getExecutionId() != null && this.isExecutionRelatedEntityCountEnabledGlobally() && this.isExecutionRelatedEntityCountEnabled(countingExecutionEntity = (CountingExecutionEntity)((Object)entity.getExecution()))) {
            countingExecutionEntity.setTaskCount(countingExecutionEntity.getTaskCount() - 1);
        }
    }

    @Override
    public List<TaskEntity> findTasksByExecutionId(String executionId) {
        return this.taskDataManager.findTasksByExecutionId(executionId);
    }

    @Override
    public List<TaskEntity> findTasksByProcessInstanceId(String processInstanceId) {
        return this.taskDataManager.findTasksByProcessInstanceId(processInstanceId);
    }

    @Override
    public List<Task> findTasksByQueryCriteria(TaskQueryImpl taskQuery) {
        return this.taskDataManager.findTasksByQueryCriteria(taskQuery);
    }

    @Override
    public List<Task> findTasksAndVariablesByQueryCriteria(TaskQueryImpl taskQuery) {
        return this.taskDataManager.findTasksAndVariablesByQueryCriteria(taskQuery);
    }

    @Override
    public long findTaskCountByQueryCriteria(TaskQueryImpl taskQuery) {
        return this.taskDataManager.findTaskCountByQueryCriteria(taskQuery);
    }

    @Override
    public List<Task> findTasksByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.taskDataManager.findTasksByNativeQuery(parameterMap, firstResult, maxResults);
    }

    @Override
    public long findTaskCountByNativeQuery(Map<String, Object> parameterMap) {
        return this.taskDataManager.findTaskCountByNativeQuery(parameterMap);
    }

    @Override
    public List<Task> findTasksByParentTaskId(String parentTaskId) {
        return this.taskDataManager.findTasksByParentTaskId(parentTaskId);
    }

    @Override
    public void deleteTask(String taskId, String deleteReason, boolean cascade, boolean cancel) {
        TaskEntity task = (TaskEntity)this.findById(taskId);
        if (task != null) {
            if (task.getExecutionId() != null) {
                throw new ActivitiException("The task cannot be deleted because is part of a running process");
            }
            this.deleteTask(task, deleteReason, cascade, cancel);
        } else if (cascade) {
            this.getHistoricTaskInstanceEntityManager().delete(taskId);
        }
    }

    @Override
    public void deleteTask(String taskId, String deleteReason, boolean cascade) {
        this.deleteTask(taskId, deleteReason, cascade, false);
    }

    @Override
    public void updateTaskTenantIdForDeployment(String deploymentId, String newTenantId) {
        this.taskDataManager.updateTaskTenantIdForDeployment(deploymentId, newTenantId);
    }

    public TaskDataManager getTaskDataManager() {
        return this.taskDataManager;
    }

    public void setTaskDataManager(TaskDataManager taskDataManager) {
        this.taskDataManager = taskDataManager;
    }
}

