/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rad.test;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.rad.test.AlfrescoTestRunner;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class RunTestWebScript
extends DeclarativeWebScript {
    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        System.out.println("RunTestWebScript: Start executing ...");
        String result = "FAILURE";
        String clazzAndMethod = null;
        String clazz = null;
        String method = null;
        Result junitRunnerResult = null;
        clazzAndMethod = (String)req.getServiceMatch().getTemplateVars().get("clazz");
        if (clazzAndMethod == null) {
            clazzAndMethod = req.getParameter("clazz");
        }
        System.out.println("RunTestWebScript: clazzAndMethod = " + clazzAndMethod);
        if (clazzAndMethod == null) {
            clazzAndMethod = "not provided";
        } else {
            Class<?> c = null;
            String[] clazzAndMethodArray = clazzAndMethod.split("#");
            if (clazzAndMethodArray.length > 1) {
                clazz = clazzAndMethodArray[0];
                method = clazzAndMethodArray[1];
            }
            System.out.println("RunTestWebScript: [clazz=" + clazz + "][method=" + method + "]");
            try {
                c = Class.forName(clazz);
            }
            catch (ClassNotFoundException ex) {
                throw new AlfrescoRuntimeException("Could not find test class: " + clazzAndMethod);
            }
            if (method == null) {
                junitRunnerResult = JUnitCore.runClasses((Class[])new Class[]{c});
            } else {
                Request jreq = Request.method(c, (String)method);
                junitRunnerResult = new JUnitCore().run(jreq);
            }
            if (junitRunnerResult.wasSuccessful()) {
                result = "SUCCESS";
            }
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        if (method == null) {
            model.put("test", clazzAndMethod);
        } else {
            model.put("test", clazzAndMethod + "#" + method);
        }
        model.put("result", result);
        if (junitRunnerResult != null) {
            model.put("resultObject", junitRunnerResult);
            model.put("failures", junitRunnerResult.getFailures());
            model.put("failureCount", junitRunnerResult.getFailureCount());
            model.put("ignoreCount", junitRunnerResult.getIgnoreCount());
            model.put("runCount", junitRunnerResult.getRunCount());
            model.put("runTime", junitRunnerResult.getRunTime());
            ArrayList<String> throwables = new ArrayList<String>();
            if (null != junitRunnerResult.getFailures()) {
                for (Failure failure : junitRunnerResult.getFailures()) {
                    try {
                        throwables.add(AlfrescoTestRunner.serializableToString(failure.getException()));
                    }
                    catch (IOException e) {
                        try {
                            throwables.add(AlfrescoTestRunner.serializableToString((Serializable)((Object)"Unable to serialize exception.")));
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            }
            model.put("throwables", throwables);
            model.put("wasSuccessful", junitRunnerResult.wasSuccessful());
        }
        System.out.println("RunTestWebScript: model = " + model);
        System.out.println("RunTestWebScript: Stopped executing");
        return model;
    }
}

