/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.api;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import java.util.HashMap;
import java.util.Map;

public final class UiThreadExecutor {
    private static final Handler HANDLER = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            Runnable callback = msg.getCallback();
            if (callback != null) {
                callback.run();
                UiThreadExecutor.decrementToken((Token)msg.obj);
            } else {
                super.handleMessage(msg);
            }
        }
    };
    private static final Map<String, Token> TOKENS = new HashMap<String, Token>();

    private UiThreadExecutor() {
    }

    public static void runTask(String id, Runnable task, long delay) {
        if ("".equals(id)) {
            HANDLER.postDelayed(task, delay);
            return;
        }
        long time = SystemClock.uptimeMillis() + delay;
        HANDLER.postAtTime(task, (Object)UiThreadExecutor.nextToken(id), time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Token nextToken(String id) {
        Map<String, Token> map = TOKENS;
        synchronized (map) {
            Token token = TOKENS.get(id);
            if (token == null) {
                token = new Token(id);
                TOKENS.put(id, token);
            }
            ++token.runnablesCount;
            return token;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void decrementToken(Token token) {
        Map<String, Token> map = TOKENS;
        synchronized (map) {
            String id;
            Token old;
            if (--token.runnablesCount == 0 && (old = TOKENS.remove(id = token.id)) != token) {
                TOKENS.put(id, old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancelAll(String id) {
        Token token;
        Map<String, Token> map = TOKENS;
        synchronized (map) {
            token = TOKENS.remove(id);
        }
        if (token == null) {
            return;
        }
        HANDLER.removeCallbacksAndMessages((Object)token);
    }

    private static final class Token {
        int runnablesCount = 0;
        final String id;

        private Token(String id) {
            this.id = id;
        }
    }
}

