// $ANTLR 3.5 org\\stringtemplate\\v4\\compiler\\Group.g 2013-01-04 21:20:26

/*
 * [The "BSD license"]
 *  Copyright (c) 2011 Terence Parr
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. The name of the author may not be used to endorse or promote products
 *     derived from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 *  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 *  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.stringtemplate.v4.compiler;

import java.util.Collections;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import java.util.ArrayList;
import org.stringtemplate.v4.misc.*;
import org.stringtemplate.v4.*;
import java.io.File;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

@SuppressWarnings("all")
public class GroupParser extends Parser {
	public static final String[] tokenNames = new String[] {
		"<invalid>", "<EOR>", "<DOWN>", "<UP>", "ANONYMOUS_TEMPLATE", "BIGSTRING", 
		"BIGSTRING_NO_NL", "COMMENT", "FALSE", "ID", "LBRACK", "LINE_COMMENT", 
		"RBRACK", "STRING", "TRUE", "WS", "'('", "')'", "','", "'.'", "':'", "'::='", 
		"';'", "'='", "'@'", "'default'", "'delimiters'", "'group'", "'implements'", 
		"'import'"
	};
	public static final int EOF=-1;
	public static final int T__16=16;
	public static final int T__17=17;
	public static final int T__18=18;
	public static final int T__19=19;
	public static final int T__20=20;
	public static final int T__21=21;
	public static final int T__22=22;
	public static final int T__23=23;
	public static final int T__24=24;
	public static final int T__25=25;
	public static final int T__26=26;
	public static final int T__27=27;
	public static final int T__28=28;
	public static final int T__29=29;
	public static final int ANONYMOUS_TEMPLATE=4;
	public static final int BIGSTRING=5;
	public static final int BIGSTRING_NO_NL=6;
	public static final int COMMENT=7;
	public static final int FALSE=8;
	public static final int ID=9;
	public static final int LBRACK=10;
	public static final int LINE_COMMENT=11;
	public static final int RBRACK=12;
	public static final int STRING=13;
	public static final int TRUE=14;
	public static final int WS=15;

	// delegates
	public Parser[] getDelegates() {
		return new Parser[] {};
	}

	// delegators


	public GroupParser(TokenStream input) {
		this(input, new RecognizerSharedState());
	}
	public GroupParser(TokenStream input, RecognizerSharedState state) {
		super(input, state);
	}

	@Override public String[] getTokenNames() { return GroupParser.tokenNames; }
	@Override public String getGrammarFileName() { return "org\\stringtemplate\\v4\\compiler\\Group.g"; }


	public STGroup group;

	@Override
	public void displayRecognitionError(String[] tokenNames,
	                                    RecognitionException e)
	{
	    String msg = getErrorMessage(e, tokenNames);
	    group.errMgr.groupSyntaxError(ErrorType.SYNTAX_ERROR, getSourceName(), e, msg);
	}
	@Override
	public String getSourceName() {
	    String fullFileName = super.getSourceName();
	    File f = new File(fullFileName); // strip to simple name
	    return f.getName();
	}
	public void error(String msg) {
	    NoViableAltException e = new NoViableAltException("", 0, 0, input);
	    group.errMgr.groupSyntaxError(ErrorType.SYNTAX_ERROR, getSourceName(), e, msg);
	    recover(input, null);
	}



	// $ANTLR start "group"
	// org\\stringtemplate\\v4\\compiler\\Group.g:160:1: group[STGroup group, String prefix] : ( oldStyleHeader )? ( delimiters )? ( 'import' STRING | 'import' ID ( '.' ID )* )* ( def[prefix] )+ ;
	public final void group(STGroup group, String prefix) throws RecognitionException {
		Token STRING1=null;


		GroupLexer lexer = (GroupLexer)input.getTokenSource();
		this.group = lexer.group = group;

		try {
			// org\\stringtemplate\\v4\\compiler\\Group.g:165:2: ( ( oldStyleHeader )? ( delimiters )? ( 'import' STRING | 'import' ID ( '.' ID )* )* ( def[prefix] )+ )
			// org\\stringtemplate\\v4\\compiler\\Group.g:165:4: ( oldStyleHeader )? ( delimiters )? ( 'import' STRING | 'import' ID ( '.' ID )* )* ( def[prefix] )+
			{
			// org\\stringtemplate\\v4\\compiler\\Group.g:165:4: ( oldStyleHeader )?
			int alt1=2;
			int LA1_0 = input.LA(1);
			if ( (LA1_0==27) ) {
				alt1=1;
			}
			switch (alt1) {
				case 1 :
					// org\\stringtemplate\\v4\\compiler\\Group.g:165:4: oldStyleHeader
					{
					pushFollow(FOLLOW_oldStyleHeader_in_group86);
					oldStyleHeader();
					state._fsp--;

					}
					break;

			}

			// org\\stringtemplate\\v4\\compiler\\Group.g:166:3: ( delimiters )?
			int alt2=2;
			int LA2_0 = input.LA(1);
			if ( (LA2_0==26) ) {
				alt2=1;
			}
			switch (alt2) {
				case 1 :
					// org\\stringtemplate\\v4\\compiler\\Group.g:166:3: delimiters
					{
					pushFollow(FOLLOW_delimiters_in_group91);
					delimiters();
					state._fsp--;

					}
					break;

			}

			// org\\stringtemplate\\v4\\compiler\\Group.g:167:6: ( 'import' STRING | 'import' ID ( '.' ID )* )*
			loop4:
			while (true) {
				int alt4=3;
				int LA4_0 = input.LA(1);
				if ( (LA4_0==29) ) {
					int LA4_2 = input.LA(2);
					if ( (LA4_2==STRING) ) {
						alt4=1;
					}
					else if ( (LA4_2==ID) ) {
						alt4=2;
					}

				}

				switch (alt4) {
				case 1 :
					// org\\stringtemplate\\v4\\compiler\\Group.g:167:8: 'import' STRING
					{
					match(input,29,FOLLOW_29_in_group101); 
					STRING1=(Token)match(input,STRING,FOLLOW_STRING_in_group103); 
					group.importTemplates(STRING1);
					}
					break;
				case 2 :
					// org\\stringtemplate\\v4\\compiler\\Group.g:168:5: 'import' ID ( '.' ID )*
					{
					match(input,29,FOLLOW_29_in_group111); 

								MismatchedTokenException e = new MismatchedTokenException(STRING, input);
								reportError(e);
								
					match(input,ID,FOLLOW_ID_in_group122); 
					// org\\stringtemplate\\v4\\compiler\\Group.g:173:7: ( '.' ID )*
					loop3:
					while (true) {
						int alt3=2;
						int LA3_0 = input.LA(1);
						if ( (LA3_0==19) ) {
							alt3=1;
						}

						switch (alt3) {
						case 1 :
							// org\\stringtemplate\\v4\\compiler\\Group.g:173:8: '.' ID
							{
							match(input,19,FOLLOW_19_in_group125); 
							match(input,ID,FOLLOW_ID_in_group127); 
							}
							break;

						default :
							break loop3;
						}
					}

					}
					break;

				default :
					break loop4;
				}
			}

			// org\\stringtemplate\\v4\\compiler\\Group.g:175:9: ( def[prefix] )+
			int cnt5=0;
			loop5:
			while (true) {
				int alt5=2;
				int LA5_0 = input.LA(1);
				if ( (LA5_0==ID||LA5_0==24) ) {
					alt5=1;
				}

				switch (alt5) {
				case 1 :
					// org\\stringtemplate\\v4\\compiler\\Group.g:175:9: def[prefix]
					{
					pushFollow(FOLLOW_def_in_group145);
					def(prefix);
					state._fsp--;

					}
					break;

				default :
					if ( cnt5 >= 1 ) break loop5;
					EarlyExitException eee = new EarlyExitException(5, input);
					throw eee;
				}
				cnt5++;
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "group"



	// $ANTLR start "oldStyleHeader"
	// org\\stringtemplate\\v4\\compiler\\Group.g:178:1: oldStyleHeader : 'group' ID ( ':' ID )? ( 'implements' ID ( ',' ID )* )? ';' ;
	public final void oldStyleHeader() throws RecognitionException {
		try {
			// org\\stringtemplate\\v4\\compiler\\Group.g:179:5: ( 'group' ID ( ':' ID )? ( 'implements' ID ( ',' ID )* )? ';' )
			// org\\stringtemplate\\v4\\compiler\\Group.g:179:9: 'group' ID ( ':' ID )? ( 'implements' ID ( ',' ID )* )? ';'
			{
			match(input,27,FOLLOW_27_in_oldStyleHeader167); 
			match(input,ID,FOLLOW_ID_in_oldStyleHeader169); 
			// org\\stringtemplate\\v4\\compiler\\Group.g:179:20: ( ':' ID )?
			int alt6=2;
			int LA6_0 = input.LA(1);
			if ( (LA6_0==20) ) {
				alt6=1;
			}
			switch (alt6) {
				case 1 :
					// org\\stringtemplate\\v4\\compiler\\Group.g:179:22: ':' ID
					{
					match(input,20,FOLLOW_20_in_oldStyleHeader173); 
					match(input,ID,FOLLOW_ID_in_oldStyleHeader175); 
					}
					break;

			}

			// org\\stringtemplate\\v4\\compiler\\Group.g:180:6: ( 'implements' ID ( ',' ID )* )?
			int alt8=2;
			int LA8_0 = input.LA(1);
			if ( (LA8_0==28) ) {
				alt8=1;
			}
			switch (alt8) {
				case 1 :
					// org\\stringtemplate\\v4\\compiler\\Group.g:180:8: 'implements' ID ( ',' ID )*
					{
					match(input,28,FOLLOW_28_in_oldStyleHeader187); 
					match(input,ID,FOLLOW_ID_in_oldStyleHeader189); 
					// org\\stringtemplate\\v4\\compiler\\Group.g:180:24: ( ',' ID )*
					loop7:
					while (true) {
						int alt7=2;
						int LA7_0 = input.LA(1);
						if ( (LA7_0==18) ) {
							alt7=1;
						}

						switch (alt7) {
						case 1 :
							// org\\stringtemplate\\v4\\compiler\\Group.g:180:25: ',' ID
							{
							match(input,18,FOLLOW_18_in_oldStyleHeader192); 
							match(input,ID,FOLLOW_ID_in_oldStyleHeader194); 
							}
							break;

						default :
							break loop7;
						}
					}

					}
					break;

			}

			match(input,22,FOLLOW_22_in_oldStyleHeader206); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "oldStyleHeader"



	// $ANTLR start "groupName"
	// org\\stringtemplate\\v4\\compiler\\Group.g:184:1: groupName returns [String name] : a= ID ( '.' a= ID )* ;
	public final String groupName() throws RecognitionException {
		String name = null;


		Token a=null;

		StringBuilder buf = new StringBuilder();
		try {
			// org\\stringtemplate\\v4\\compiler\\Group.g:186:2: (a= ID ( '.' a= ID )* )
			// org\\stringtemplate\\v4\\compiler\\Group.g:186:4: a= ID ( '.' a= ID )*
			{
			a=(Token)match(input,ID,FOLLOW_ID_in_groupName228); 
			buf.append((a!=null?a.getText():null));
			// org\\stringtemplate\\v4\\compiler\\Group.g:186:32: ( '.' a= ID )*
			loop9:
			while (true) {
				int alt9=2;
				int LA9_0 = input.LA(1);
				if ( (LA9_0==19) ) {
					alt9=1;
				}

				switch (alt9) {
				case 1 :
					// org\\stringtemplate\\v4\\compiler\\Group.g:186:33: '.' a= ID
					{
					match(input,19,FOLLOW_19_in_groupName233); 
					a=(Token)match(input,ID,FOLLOW_ID_in_groupName237); 
					buf.append((a!=null?a.getText():null));
					}
					break;

				default :
					break loop9;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return name;
	}
	// $ANTLR end "groupName"



	// $ANTLR start "delimiters"
	// org\\stringtemplate\\v4\\compiler\\Group.g:189:1: delimiters : 'delimiters' a= STRING ',' b= STRING ;
	public final void delimiters() throws RecognitionException {
		Token a=null;
		Token b=null;

		try {
			// org\\stringtemplate\\v4\\compiler\\Group.g:190:5: ( 'delimiters' a= STRING ',' b= STRING )
			// org\\stringtemplate\\v4\\compiler\\Group.g:190:7: 'delimiters' a= STRING ',' b= STRING
			{
			match(input,26,FOLLOW_26_in_delimiters255); 
			a=(Token)match(input,STRING,FOLLOW_STRING_in_delimiters259); 
			match(input,18,FOLLOW_18_in_delimiters261); 
			b=(Token)match(input,STRING,FOLLOW_STRING_in_delimiters265); 

			     	group.delimiterStartChar=a.getText().charAt(1);
			        group.delimiterStopChar=b.getText().charAt(1);
			        
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "delimiters"



	// $ANTLR start "def"
	// org\\stringtemplate\\v4\\compiler\\Group.g:201:1: def[String prefix] : ( templateDef[prefix] | dictDef );
	public final void def(String prefix) throws RecognitionException {
		try {
			// org\\stringtemplate\\v4\\compiler\\Group.g:201:20: ( templateDef[prefix] | dictDef )
			int alt10=2;
			int LA10_0 = input.LA(1);
			if ( (LA10_0==24) ) {
				alt10=1;
			}
			else if ( (LA10_0==ID) ) {
				int LA10_2 = input.LA(2);
				if ( (LA10_2==16) ) {
					alt10=1;
				}
				else if ( (LA10_2==21) ) {
					int LA10_3 = input.LA(3);
					if ( (LA10_3==ID) ) {
						alt10=1;
					}
					else if ( (LA10_3==LBRACK) ) {
						alt10=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 10, 3, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 10, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 10, 0, input);
				throw nvae;
			}

			switch (alt10) {
				case 1 :
					// org\\stringtemplate\\v4\\compiler\\Group.g:201:22: templateDef[prefix]
					{
					pushFollow(FOLLOW_templateDef_in_def289);
					templateDef(prefix);
					state._fsp--;

					}
					break;
				case 2 :
					// org\\stringtemplate\\v4\\compiler\\Group.g:201:44: dictDef
					{
					pushFollow(FOLLOW_dictDef_in_def294);
					dictDef();
					state._fsp--;

					}
					break;

			}
		}
		catch (RecognitionException re) {

					// pretend we already saw an error here
					state.lastErrorIndex = input.index();
					error("garbled template definition starting at '"+input.LT(1).getText()+"'");
				
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "def"



	// $ANTLR start "templateDef"
	// org\\stringtemplate\\v4\\compiler\\Group.g:208:1: templateDef[String prefix] : ( ( '@' enclosing= ID '.' name= ID '(' ')' |name= ID '(' formalArgs ')' ) '::=' ( STRING | BIGSTRING | BIGSTRING_NO_NL |) |alias= ID '::=' target= ID );
	public final void templateDef(String prefix) throws RecognitionException {
		Token enclosing=null;
		Token name=null;
		Token alias=null;
		Token target=null;
		Token STRING2=null;
		Token BIGSTRING3=null;
		Token BIGSTRING_NO_NL4=null;
		List<FormalArgument> formalArgs5 =null;


		    String template=null;
		    int n=0; // num char to strip from left, right of template def

		try {
			// org\\stringtemplate\\v4\\compiler\\Group.g:213:2: ( ( '@' enclosing= ID '.' name= ID '(' ')' |name= ID '(' formalArgs ')' ) '::=' ( STRING | BIGSTRING | BIGSTRING_NO_NL |) |alias= ID '::=' target= ID )
			int alt13=2;
			int LA13_0 = input.LA(1);
			if ( (LA13_0==24) ) {
				alt13=1;
			}
			else if ( (LA13_0==ID) ) {
				int LA13_2 = input.LA(2);
				if ( (LA13_2==16) ) {
					alt13=1;
				}
				else if ( (LA13_2==21) ) {
					alt13=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 13, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 13, 0, input);
				throw nvae;
			}

			switch (alt13) {
				case 1 :
					// org\\stringtemplate\\v4\\compiler\\Group.g:213:4: ( '@' enclosing= ID '.' name= ID '(' ')' |name= ID '(' formalArgs ')' ) '::=' ( STRING | BIGSTRING | BIGSTRING_NO_NL |)
					{
					// org\\stringtemplate\\v4\\compiler\\Group.g:213:4: ( '@' enclosing= ID '.' name= ID '(' ')' |name= ID '(' formalArgs ')' )
					int alt11=2;
					int LA11_0 = input.LA(1);
					if ( (LA11_0==24) ) {
						alt11=1;
					}
					else if ( (LA11_0==ID) ) {
						alt11=2;
					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 11, 0, input);
						throw nvae;
					}

					switch (alt11) {
						case 1 :
							// org\\stringtemplate\\v4\\compiler\\Group.g:213:6: '@' enclosing= ID '.' name= ID '(' ')'
							{
							match(input,24,FOLLOW_24_in_templateDef318); 
							enclosing=(Token)match(input,ID,FOLLOW_ID_in_templateDef322); 
							match(input,19,FOLLOW_19_in_templateDef324); 
							name=(Token)match(input,ID,FOLLOW_ID_in_templateDef328); 
							match(input,16,FOLLOW_16_in_templateDef330); 
							match(input,17,FOLLOW_17_in_templateDef332); 
							}
							break;
						case 2 :
							// org\\stringtemplate\\v4\\compiler\\Group.g:214:5: name= ID '(' formalArgs ')'
							{
							name=(Token)match(input,ID,FOLLOW_ID_in_templateDef340); 
							match(input,16,FOLLOW_16_in_templateDef342); 
							pushFollow(FOLLOW_formalArgs_in_templateDef344);
							formalArgs5=formalArgs();
							state._fsp--;

							match(input,17,FOLLOW_17_in_templateDef346); 
							}
							break;

					}

					match(input,21,FOLLOW_21_in_templateDef357); 
					Token templateToken = input.LT(1);
					// org\\stringtemplate\\v4\\compiler\\Group.g:218:6: ( STRING | BIGSTRING | BIGSTRING_NO_NL |)
					int alt12=4;
					switch ( input.LA(1) ) {
					case STRING:
						{
						alt12=1;
						}
						break;
					case BIGSTRING:
						{
						alt12=2;
						}
						break;
					case BIGSTRING_NO_NL:
						{
						alt12=3;
						}
						break;
					case EOF:
					case ID:
					case 24:
						{
						alt12=4;
						}
						break;
					default:
						NoViableAltException nvae =
							new NoViableAltException("", 12, 0, input);
						throw nvae;
					}
					switch (alt12) {
						case 1 :
							// org\\stringtemplate\\v4\\compiler\\Group.g:218:8: STRING
							{
							STRING2=(Token)match(input,STRING,FOLLOW_STRING_in_templateDef373); 
							template=(STRING2!=null?STRING2.getText():null); n=1;
							}
							break;
						case 2 :
							// org\\stringtemplate\\v4\\compiler\\Group.g:219:8: BIGSTRING
							{
							BIGSTRING3=(Token)match(input,BIGSTRING,FOLLOW_BIGSTRING_in_templateDef388); 
							template=(BIGSTRING3!=null?BIGSTRING3.getText():null); n=2;
							}
							break;
						case 3 :
							// org\\stringtemplate\\v4\\compiler\\Group.g:220:8: BIGSTRING_NO_NL
							{
							BIGSTRING_NO_NL4=(Token)match(input,BIGSTRING_NO_NL,FOLLOW_BIGSTRING_NO_NL_in_templateDef400); 
							template=(BIGSTRING_NO_NL4!=null?BIGSTRING_NO_NL4.getText():null); n=2;
							}
							break;
						case 4 :
							// org\\stringtemplate\\v4\\compiler\\Group.g:221:8: 
							{

								    	template = "";
								    	String msg = "missing template at '"+input.LT(1).getText()+"'";
							            NoViableAltException e = new NoViableAltException("", 0, 0, input);
							    	    group.errMgr.groupSyntaxError(ErrorType.SYNTAX_ERROR, getSourceName(), e, msg);
							    	    
							}
							break;

					}


						    if ( (name!=null?name.getTokenIndex():0) >= 0 ) { // if ID missing
								template = Misc.strip(template, n);
								String templateName = (name!=null?name.getText():null);
								if ( prefix.length()>0 ) templateName = prefix+(name!=null?name.getText():null);
								String enclosingTemplateName = (enclosing!=null?enclosing.getText():null);
								if (enclosingTemplateName != null && enclosingTemplateName.length()>0 && prefix.length()>0) {
									enclosingTemplateName = prefix + enclosingTemplateName;
								}
								group.defineTemplateOrRegion(templateName, enclosingTemplateName, templateToken,
															 template, name, formalArgs5);
							}
						    
					}
					break;
				case 2 :
					// org\\stringtemplate\\v4\\compiler\\Group.g:241:6: alias= ID '::=' target= ID
					{
					alias=(Token)match(input,ID,FOLLOW_ID_in_templateDef435); 
					match(input,21,FOLLOW_21_in_templateDef437); 
					target=(Token)match(input,ID,FOLLOW_ID_in_templateDef441); 
					group.defineTemplateAlias(alias, target);
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "templateDef"


	protected static class formalArgs_scope {
		boolean hasOptionalParameter;
	}
	protected Stack<formalArgs_scope> formalArgs_stack = new Stack<formalArgs_scope>();


	// $ANTLR start "formalArgs"
	// org\\stringtemplate\\v4\\compiler\\Group.g:244:1: formalArgs returns [List<FormalArgument> args = new ArrayList<FormalArgument>()] : ( formalArg[$args] ( ',' formalArg[$args] )* |);
	public final List<FormalArgument> formalArgs() throws RecognitionException {
		formalArgs_stack.push(new formalArgs_scope());
		List<FormalArgument> args =  new ArrayList<FormalArgument>();


		 formalArgs_stack.peek().hasOptionalParameter = false; 
		try {
			// org\\stringtemplate\\v4\\compiler\\Group.g:249:2: ( formalArg[$args] ( ',' formalArg[$args] )* |)
			int alt15=2;
			int LA15_0 = input.LA(1);
			if ( (LA15_0==ID) ) {
				alt15=1;
			}
			else if ( (LA15_0==17) ) {
				alt15=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 15, 0, input);
				throw nvae;
			}

			switch (alt15) {
				case 1 :
					// org\\stringtemplate\\v4\\compiler\\Group.g:249:4: formalArg[$args] ( ',' formalArg[$args] )*
					{
					pushFollow(FOLLOW_formalArg_in_formalArgs467);
					formalArg(args);
					state._fsp--;

					// org\\stringtemplate\\v4\\compiler\\Group.g:249:21: ( ',' formalArg[$args] )*
					loop14:
					while (true) {
						int alt14=2;
						int LA14_0 = input.LA(1);
						if ( (LA14_0==18) ) {
							alt14=1;
						}

						switch (alt14) {
						case 1 :
							// org\\stringtemplate\\v4\\compiler\\Group.g:249:22: ',' formalArg[$args]
							{
							match(input,18,FOLLOW_18_in_formalArgs471); 
							pushFollow(FOLLOW_formalArg_in_formalArgs473);
							formalArg(args);
							state._fsp--;

							}
							break;

						default :
							break loop14;
						}
					}

					}
					break;
				case 2 :
					// org\\stringtemplate\\v4\\compiler\\Group.g:251:2: 
					{
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
			formalArgs_stack.pop();
		}
		return args;
	}
	// $ANTLR end "formalArgs"



	// $ANTLR start "formalArg"
	// org\\stringtemplate\\v4\\compiler\\Group.g:253:1: formalArg[List<FormalArgument> args] : ID ( '=' a= ( STRING | ANONYMOUS_TEMPLATE | 'true' | 'false' ) | '=' a= '[' ']' |) ;
	public final void formalArg(List<FormalArgument> args) throws RecognitionException {
		Token a=null;
		Token ID6=null;

		try {
			// org\\stringtemplate\\v4\\compiler\\Group.g:254:2: ( ID ( '=' a= ( STRING | ANONYMOUS_TEMPLATE | 'true' | 'false' ) | '=' a= '[' ']' |) )
			// org\\stringtemplate\\v4\\compiler\\Group.g:254:4: ID ( '=' a= ( STRING | ANONYMOUS_TEMPLATE | 'true' | 'false' ) | '=' a= '[' ']' |)
			{
			ID6=(Token)match(input,ID,FOLLOW_ID_in_formalArg491); 
			// org\\stringtemplate\\v4\\compiler\\Group.g:255:3: ( '=' a= ( STRING | ANONYMOUS_TEMPLATE | 'true' | 'false' ) | '=' a= '[' ']' |)
			int alt16=3;
			int LA16_0 = input.LA(1);
			if ( (LA16_0==23) ) {
				int LA16_1 = input.LA(2);
				if ( (LA16_1==ANONYMOUS_TEMPLATE||LA16_1==FALSE||(LA16_1 >= STRING && LA16_1 <= TRUE)) ) {
					alt16=1;
				}
				else if ( (LA16_1==LBRACK) ) {
					alt16=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 16, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}
			else if ( ((LA16_0 >= 17 && LA16_0 <= 18)) ) {
				alt16=3;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 16, 0, input);
				throw nvae;
			}

			switch (alt16) {
				case 1 :
					// org\\stringtemplate\\v4\\compiler\\Group.g:255:5: '=' a= ( STRING | ANONYMOUS_TEMPLATE | 'true' | 'false' )
					{
					match(input,23,FOLLOW_23_in_formalArg497); 
					a=input.LT(1);
					if ( input.LA(1)==ANONYMOUS_TEMPLATE||input.LA(1)==FALSE||(input.LA(1) >= STRING && input.LA(1) <= TRUE) ) {
						input.consume();
						state.errorRecovery=false;
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					formalArgs_stack.peek().hasOptionalParameter = true;
					}
					break;
				case 2 :
					// org\\stringtemplate\\v4\\compiler\\Group.g:256:5: '=' a= '[' ']'
					{
					match(input,23,FOLLOW_23_in_formalArg517); 
					a=(Token)match(input,LBRACK,FOLLOW_LBRACK_in_formalArg521); 
					match(input,RBRACK,FOLLOW_RBRACK_in_formalArg523); 
					formalArgs_stack.peek().hasOptionalParameter = true;
					}
					break;
				case 3 :
					// org\\stringtemplate\\v4\\compiler\\Group.g:257:5: 
					{

								if (formalArgs_stack.peek().hasOptionalParameter) {
									group.errMgr.compileTimeError(ErrorType.REQUIRED_PARAMETER_AFTER_OPTIONAL,
									 							  null, ID6);
								}
								
					}
					break;

			}

			args.add(new FormalArgument((ID6!=null?ID6.getText():null), a));
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "formalArg"



	// $ANTLR start "dictDef"
	// org\\stringtemplate\\v4\\compiler\\Group.g:276:1: dictDef : ID '::=' dict ;
	public final void dictDef() throws RecognitionException {
		Token ID7=null;
		Map<String,Object> dict8 =null;

		try {
			// org\\stringtemplate\\v4\\compiler\\Group.g:277:2: ( ID '::=' dict )
			// org\\stringtemplate\\v4\\compiler\\Group.g:277:4: ID '::=' dict
			{
			ID7=(Token)match(input,ID,FOLLOW_ID_in_dictDef556); 
			match(input,21,FOLLOW_21_in_dictDef558); 
			pushFollow(FOLLOW_dict_in_dictDef560);
			dict8=dict();
			state._fsp--;


			        if ( group.rawGetDictionary((ID7!=null?ID7.getText():null))!=null ) {
						group.errMgr.compileTimeError(ErrorType.MAP_REDEFINITION, null, ID7);
			        }
			        else if ( group.rawGetTemplate((ID7!=null?ID7.getText():null))!=null ) {
						group.errMgr.compileTimeError(ErrorType.TEMPLATE_REDEFINITION_AS_MAP, null, ID7);
			        }
			        else {
			            group.defineDictionary((ID7!=null?ID7.getText():null), dict8);
			        }
			        
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "dictDef"



	// $ANTLR start "dict"
	// org\\stringtemplate\\v4\\compiler\\Group.g:291:1: dict returns [Map<String,Object> mapping] : '[' dictPairs[mapping] ']' ;
	public final Map<String,Object> dict() throws RecognitionException {
		Map<String,Object> mapping = null;


		mapping=new HashMap<String,Object>();
		try {
			// org\\stringtemplate\\v4\\compiler\\Group.g:293:2: ( '[' dictPairs[mapping] ']' )
			// org\\stringtemplate\\v4\\compiler\\Group.g:293:6: '[' dictPairs[mapping] ']'
			{
			match(input,LBRACK,FOLLOW_LBRACK_in_dict592); 
			pushFollow(FOLLOW_dictPairs_in_dict594);
			dictPairs(mapping);
			state._fsp--;

			match(input,RBRACK,FOLLOW_RBRACK_in_dict597); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return mapping;
	}
	// $ANTLR end "dict"



	// $ANTLR start "dictPairs"
	// org\\stringtemplate\\v4\\compiler\\Group.g:296:1: dictPairs[Map<String,Object> mapping] : ( keyValuePair[mapping] ( ',' keyValuePair[mapping] )* ( ',' defaultValuePair[mapping] )? | defaultValuePair[mapping] );
	public final void dictPairs(Map<String,Object> mapping) throws RecognitionException {
		try {
			// org\\stringtemplate\\v4\\compiler\\Group.g:297:5: ( keyValuePair[mapping] ( ',' keyValuePair[mapping] )* ( ',' defaultValuePair[mapping] )? | defaultValuePair[mapping] )
			int alt19=2;
			int LA19_0 = input.LA(1);
			if ( (LA19_0==STRING) ) {
				alt19=1;
			}
			else if ( (LA19_0==25) ) {
				alt19=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 19, 0, input);
				throw nvae;
			}

			switch (alt19) {
				case 1 :
					// org\\stringtemplate\\v4\\compiler\\Group.g:297:7: keyValuePair[mapping] ( ',' keyValuePair[mapping] )* ( ',' defaultValuePair[mapping] )?
					{
					pushFollow(FOLLOW_keyValuePair_in_dictPairs612);
					keyValuePair(mapping);
					state._fsp--;

					// org\\stringtemplate\\v4\\compiler\\Group.g:298:6: ( ',' keyValuePair[mapping] )*
					loop17:
					while (true) {
						int alt17=2;
						int LA17_0 = input.LA(1);
						if ( (LA17_0==18) ) {
							int LA17_1 = input.LA(2);
							if ( (LA17_1==STRING) ) {
								alt17=1;
							}

						}

						switch (alt17) {
						case 1 :
							// org\\stringtemplate\\v4\\compiler\\Group.g:298:7: ',' keyValuePair[mapping]
							{
							match(input,18,FOLLOW_18_in_dictPairs621); 
							pushFollow(FOLLOW_keyValuePair_in_dictPairs623);
							keyValuePair(mapping);
							state._fsp--;

							}
							break;

						default :
							break loop17;
						}
					}

					// org\\stringtemplate\\v4\\compiler\\Group.g:298:35: ( ',' defaultValuePair[mapping] )?
					int alt18=2;
					int LA18_0 = input.LA(1);
					if ( (LA18_0==18) ) {
						alt18=1;
					}
					switch (alt18) {
						case 1 :
							// org\\stringtemplate\\v4\\compiler\\Group.g:298:36: ',' defaultValuePair[mapping]
							{
							match(input,18,FOLLOW_18_in_dictPairs629); 
							pushFollow(FOLLOW_defaultValuePair_in_dictPairs631);
							defaultValuePair(mapping);
							state._fsp--;

							}
							break;

					}

					}
					break;
				case 2 :
					// org\\stringtemplate\\v4\\compiler\\Group.g:299:7: defaultValuePair[mapping]
					{
					pushFollow(FOLLOW_defaultValuePair_in_dictPairs642);
					defaultValuePair(mapping);
					state._fsp--;

					}
					break;

			}
		}
		catch (RecognitionException re) {

					error("missing dictionary entry at '"+input.LT(1).getText()+"'");
				
		}

		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "dictPairs"



	// $ANTLR start "defaultValuePair"
	// org\\stringtemplate\\v4\\compiler\\Group.g:305:1: defaultValuePair[Map<String,Object> mapping] : 'default' ':' keyValue ;
	public final void defaultValuePair(Map<String,Object> mapping) throws RecognitionException {
		Object keyValue9 =null;

		try {
			// org\\stringtemplate\\v4\\compiler\\Group.g:306:2: ( 'default' ':' keyValue )
			// org\\stringtemplate\\v4\\compiler\\Group.g:306:4: 'default' ':' keyValue
			{
			match(input,25,FOLLOW_25_in_defaultValuePair665); 
			match(input,20,FOLLOW_20_in_defaultValuePair667); 
			pushFollow(FOLLOW_keyValue_in_defaultValuePair669);
			keyValue9=keyValue();
			state._fsp--;

			mapping.put(STGroup.DEFAULT_KEY, keyValue9);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "defaultValuePair"



	// $ANTLR start "keyValuePair"
	// org\\stringtemplate\\v4\\compiler\\Group.g:309:1: keyValuePair[Map<String,Object> mapping] : STRING ':' keyValue ;
	public final void keyValuePair(Map<String,Object> mapping) throws RecognitionException {
		Token STRING10=null;
		Object keyValue11 =null;

		try {
			// org\\stringtemplate\\v4\\compiler\\Group.g:310:2: ( STRING ':' keyValue )
			// org\\stringtemplate\\v4\\compiler\\Group.g:310:4: STRING ':' keyValue
			{
			STRING10=(Token)match(input,STRING,FOLLOW_STRING_in_keyValuePair683); 
			match(input,20,FOLLOW_20_in_keyValuePair685); 
			pushFollow(FOLLOW_keyValue_in_keyValuePair687);
			keyValue11=keyValue();
			state._fsp--;

			mapping.put(Misc.replaceEscapes(Misc.strip((STRING10!=null?STRING10.getText():null), 1)), keyValue11);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "keyValuePair"



	// $ANTLR start "keyValue"
	// org\\stringtemplate\\v4\\compiler\\Group.g:313:1: keyValue returns [Object value] : ( BIGSTRING | BIGSTRING_NO_NL | ANONYMOUS_TEMPLATE | STRING | TRUE | FALSE | '[' ']' |{...}? => ID );
	public final Object keyValue() throws RecognitionException {
		Object value = null;


		Token BIGSTRING12=null;
		Token BIGSTRING_NO_NL13=null;
		Token ANONYMOUS_TEMPLATE14=null;
		Token STRING15=null;

		try {
			// org\\stringtemplate\\v4\\compiler\\Group.g:314:2: ( BIGSTRING | BIGSTRING_NO_NL | ANONYMOUS_TEMPLATE | STRING | TRUE | FALSE | '[' ']' |{...}? => ID )
			int alt20=8;
			int LA20_0 = input.LA(1);
			if ( (LA20_0==BIGSTRING) ) {
				alt20=1;
			}
			else if ( (LA20_0==BIGSTRING_NO_NL) ) {
				alt20=2;
			}
			else if ( (LA20_0==ANONYMOUS_TEMPLATE) ) {
				alt20=3;
			}
			else if ( (LA20_0==STRING) ) {
				alt20=4;
			}
			else if ( (LA20_0==TRUE) ) {
				alt20=5;
			}
			else if ( (LA20_0==FALSE) ) {
				alt20=6;
			}
			else if ( (LA20_0==LBRACK) ) {
				alt20=7;
			}
			else if ( (LA20_0==ID) && ((input.LT(1).getText().equals("key")))) {
				alt20=8;
			}

			switch (alt20) {
				case 1 :
					// org\\stringtemplate\\v4\\compiler\\Group.g:314:4: BIGSTRING
					{
					BIGSTRING12=(Token)match(input,BIGSTRING,FOLLOW_BIGSTRING_in_keyValue704); 
					value = group.createSingleton(BIGSTRING12);
					}
					break;
				case 2 :
					// org\\stringtemplate\\v4\\compiler\\Group.g:315:4: BIGSTRING_NO_NL
					{
					BIGSTRING_NO_NL13=(Token)match(input,BIGSTRING_NO_NL,FOLLOW_BIGSTRING_NO_NL_in_keyValue713); 
					value = group.createSingleton(BIGSTRING_NO_NL13);
					}
					break;
				case 3 :
					// org\\stringtemplate\\v4\\compiler\\Group.g:316:4: ANONYMOUS_TEMPLATE
					{
					ANONYMOUS_TEMPLATE14=(Token)match(input,ANONYMOUS_TEMPLATE,FOLLOW_ANONYMOUS_TEMPLATE_in_keyValue721); 
					value = group.createSingleton(ANONYMOUS_TEMPLATE14);
					}
					break;
				case 4 :
					// org\\stringtemplate\\v4\\compiler\\Group.g:317:4: STRING
					{
					STRING15=(Token)match(input,STRING,FOLLOW_STRING_in_keyValue728); 
					value = Misc.replaceEscapes(Misc.strip((STRING15!=null?STRING15.getText():null), 1));
					}
					break;
				case 5 :
					// org\\stringtemplate\\v4\\compiler\\Group.g:318:4: TRUE
					{
					match(input,TRUE,FOLLOW_TRUE_in_keyValue738); 
					value = true;
					}
					break;
				case 6 :
					// org\\stringtemplate\\v4\\compiler\\Group.g:319:4: FALSE
					{
					match(input,FALSE,FOLLOW_FALSE_in_keyValue748); 
					value = false;
					}
					break;
				case 7 :
					// org\\stringtemplate\\v4\\compiler\\Group.g:320:4: '[' ']'
					{
					match(input,LBRACK,FOLLOW_LBRACK_in_keyValue758); 
					match(input,RBRACK,FOLLOW_RBRACK_in_keyValue760); 
					value = Collections.emptyList();
					}
					break;
				case 8 :
					// org\\stringtemplate\\v4\\compiler\\Group.g:321:4: {...}? => ID
					{
					if ( !((input.LT(1).getText().equals("key"))) ) {
						throw new FailedPredicateException(input, "keyValue", "input.LT(1).getText().equals(\"key\")");
					}
					match(input,ID,FOLLOW_ID_in_keyValue773); 
					value = STGroup.DICT_KEY;
					}
					break;

			}
		}
		catch (RecognitionException re) {

					error("missing value for key at '"+input.LT(1).getText()+"'");
				
		}

		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "keyValue"

	// Delegated rules



	public static final BitSet FOLLOW_oldStyleHeader_in_group86 = new BitSet(new long[]{0x0000000025000200L});
	public static final BitSet FOLLOW_delimiters_in_group91 = new BitSet(new long[]{0x0000000021000200L});
	public static final BitSet FOLLOW_29_in_group101 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_STRING_in_group103 = new BitSet(new long[]{0x0000000021000200L});
	public static final BitSet FOLLOW_29_in_group111 = new BitSet(new long[]{0x0000000000000200L});
	public static final BitSet FOLLOW_ID_in_group122 = new BitSet(new long[]{0x0000000021080200L});
	public static final BitSet FOLLOW_19_in_group125 = new BitSet(new long[]{0x0000000000000200L});
	public static final BitSet FOLLOW_ID_in_group127 = new BitSet(new long[]{0x0000000021080200L});
	public static final BitSet FOLLOW_def_in_group145 = new BitSet(new long[]{0x0000000001000202L});
	public static final BitSet FOLLOW_27_in_oldStyleHeader167 = new BitSet(new long[]{0x0000000000000200L});
	public static final BitSet FOLLOW_ID_in_oldStyleHeader169 = new BitSet(new long[]{0x0000000010500000L});
	public static final BitSet FOLLOW_20_in_oldStyleHeader173 = new BitSet(new long[]{0x0000000000000200L});
	public static final BitSet FOLLOW_ID_in_oldStyleHeader175 = new BitSet(new long[]{0x0000000010400000L});
	public static final BitSet FOLLOW_28_in_oldStyleHeader187 = new BitSet(new long[]{0x0000000000000200L});
	public static final BitSet FOLLOW_ID_in_oldStyleHeader189 = new BitSet(new long[]{0x0000000000440000L});
	public static final BitSet FOLLOW_18_in_oldStyleHeader192 = new BitSet(new long[]{0x0000000000000200L});
	public static final BitSet FOLLOW_ID_in_oldStyleHeader194 = new BitSet(new long[]{0x0000000000440000L});
	public static final BitSet FOLLOW_22_in_oldStyleHeader206 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ID_in_groupName228 = new BitSet(new long[]{0x0000000000080002L});
	public static final BitSet FOLLOW_19_in_groupName233 = new BitSet(new long[]{0x0000000000000200L});
	public static final BitSet FOLLOW_ID_in_groupName237 = new BitSet(new long[]{0x0000000000080002L});
	public static final BitSet FOLLOW_26_in_delimiters255 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_STRING_in_delimiters259 = new BitSet(new long[]{0x0000000000040000L});
	public static final BitSet FOLLOW_18_in_delimiters261 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_STRING_in_delimiters265 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_templateDef_in_def289 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dictDef_in_def294 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_24_in_templateDef318 = new BitSet(new long[]{0x0000000000000200L});
	public static final BitSet FOLLOW_ID_in_templateDef322 = new BitSet(new long[]{0x0000000000080000L});
	public static final BitSet FOLLOW_19_in_templateDef324 = new BitSet(new long[]{0x0000000000000200L});
	public static final BitSet FOLLOW_ID_in_templateDef328 = new BitSet(new long[]{0x0000000000010000L});
	public static final BitSet FOLLOW_16_in_templateDef330 = new BitSet(new long[]{0x0000000000020000L});
	public static final BitSet FOLLOW_17_in_templateDef332 = new BitSet(new long[]{0x0000000000200000L});
	public static final BitSet FOLLOW_ID_in_templateDef340 = new BitSet(new long[]{0x0000000000010000L});
	public static final BitSet FOLLOW_16_in_templateDef342 = new BitSet(new long[]{0x0000000000020200L});
	public static final BitSet FOLLOW_formalArgs_in_templateDef344 = new BitSet(new long[]{0x0000000000020000L});
	public static final BitSet FOLLOW_17_in_templateDef346 = new BitSet(new long[]{0x0000000000200000L});
	public static final BitSet FOLLOW_21_in_templateDef357 = new BitSet(new long[]{0x0000000000002062L});
	public static final BitSet FOLLOW_STRING_in_templateDef373 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BIGSTRING_in_templateDef388 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BIGSTRING_NO_NL_in_templateDef400 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ID_in_templateDef435 = new BitSet(new long[]{0x0000000000200000L});
	public static final BitSet FOLLOW_21_in_templateDef437 = new BitSet(new long[]{0x0000000000000200L});
	public static final BitSet FOLLOW_ID_in_templateDef441 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_formalArg_in_formalArgs467 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_18_in_formalArgs471 = new BitSet(new long[]{0x0000000000000200L});
	public static final BitSet FOLLOW_formalArg_in_formalArgs473 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_ID_in_formalArg491 = new BitSet(new long[]{0x0000000000800002L});
	public static final BitSet FOLLOW_23_in_formalArg497 = new BitSet(new long[]{0x0000000000006110L});
	public static final BitSet FOLLOW_set_in_formalArg501 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_23_in_formalArg517 = new BitSet(new long[]{0x0000000000000400L});
	public static final BitSet FOLLOW_LBRACK_in_formalArg521 = new BitSet(new long[]{0x0000000000001000L});
	public static final BitSet FOLLOW_RBRACK_in_formalArg523 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ID_in_dictDef556 = new BitSet(new long[]{0x0000000000200000L});
	public static final BitSet FOLLOW_21_in_dictDef558 = new BitSet(new long[]{0x0000000000000400L});
	public static final BitSet FOLLOW_dict_in_dictDef560 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LBRACK_in_dict592 = new BitSet(new long[]{0x0000000002002000L});
	public static final BitSet FOLLOW_dictPairs_in_dict594 = new BitSet(new long[]{0x0000000000001000L});
	public static final BitSet FOLLOW_RBRACK_in_dict597 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_keyValuePair_in_dictPairs612 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_18_in_dictPairs621 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_keyValuePair_in_dictPairs623 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_18_in_dictPairs629 = new BitSet(new long[]{0x0000000002000000L});
	public static final BitSet FOLLOW_defaultValuePair_in_dictPairs631 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_defaultValuePair_in_dictPairs642 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_25_in_defaultValuePair665 = new BitSet(new long[]{0x0000000000100000L});
	public static final BitSet FOLLOW_20_in_defaultValuePair667 = new BitSet(new long[]{0x0000000000006770L});
	public static final BitSet FOLLOW_keyValue_in_defaultValuePair669 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_in_keyValuePair683 = new BitSet(new long[]{0x0000000000100000L});
	public static final BitSet FOLLOW_20_in_keyValuePair685 = new BitSet(new long[]{0x0000000000006770L});
	public static final BitSet FOLLOW_keyValue_in_keyValuePair687 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BIGSTRING_in_keyValue704 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BIGSTRING_NO_NL_in_keyValue713 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ANONYMOUS_TEMPLATE_in_keyValue721 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_in_keyValue728 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TRUE_in_keyValue738 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FALSE_in_keyValue748 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LBRACK_in_keyValue758 = new BitSet(new long[]{0x0000000000001000L});
	public static final BitSet FOLLOW_RBRACK_in_keyValue760 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ID_in_keyValue773 = new BitSet(new long[]{0x0000000000000002L});
}
