/*
 * Decompiled with CFR 0.152.
 */
package org.antora.maven;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;

public class FileSideloader {
    private File gitdir;

    public FileSideloader(File dir) throws IOException {
        this.gitdir = this.resolveGitDir(dir);
    }

    public void sideload(String revPath, File toFile) throws IOException {
        try (FileOutputStream os = new FileOutputStream(toFile);
             Repository repo = ((RepositoryBuilder)new RepositoryBuilder().setGitDir(this.gitdir)).build();){
            ObjectId resolvedObjectId = repo.resolve(revPath);
            if (resolvedObjectId == null) {
                throw new IOException("revpath not found in local repository: " + revPath);
            }
            repo.newObjectReader().open((AnyObjectId)resolvedObjectId).copyTo((OutputStream)os);
        }
    }

    private File resolveGitDir(File basedir) throws IOException {
        File gitdir = ((RepositoryBuilder)new RepositoryBuilder().findGitDir(basedir)).getGitDir();
        if (gitdir == null) {
            throw new IOException("Could not resolve git repository for " + String.valueOf(basedir));
        }
        File commondirFile = new File(gitdir, "commondir");
        if (commondirFile.exists()) {
            String relativePathToMainGitdir = Files.readString(commondirFile.toPath()).stripTrailing();
            gitdir = new File(gitdir, relativePathToMainGitdir).getCanonicalFile();
        }
        return gitdir;
    }
}

