/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.trace.instrument;

import org.apache.accumulo.trace.instrument.Span;
import org.apache.accumulo.trace.instrument.Trace;

public class TraceRunnable
implements Runnable,
Comparable<TraceRunnable> {
    private final Span parent;
    private final Runnable runnable;

    public TraceRunnable(Runnable runnable) {
        this(Trace.currentTrace(), runnable);
    }

    public TraceRunnable(Span parent, Runnable runnable) {
        this.parent = parent;
        this.runnable = runnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.parent != null) {
            Span chunk = Trace.startThread(this.parent, Thread.currentThread().getName());
            try {
                this.runnable.run();
            }
            finally {
                Trace.endThread(chunk);
            }
        } else {
            this.runnable.run();
        }
    }

    public boolean equals(Object o) {
        if (o instanceof TraceRunnable) {
            return 0 == this.compareTo((TraceRunnable)o);
        }
        return false;
    }

    @Override
    public int compareTo(TraceRunnable o) {
        return ((Comparable)((Object)this.runnable)).compareTo(o.runnable);
    }
}

