/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.camel.component;

import java.lang.reflect.Constructor;
import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.Service;
import org.apache.activemq.camel.component.ActiveMQComponent;
import org.apache.camel.component.jms.JmsConfiguration;
import org.springframework.jms.connection.JmsTransactionManager;
import org.springframework.jms.connection.SingleConnectionFactory;
import org.springframework.transaction.PlatformTransactionManager;

public class ActiveMQConfiguration
extends JmsConfiguration {
    private String brokerURL = org.apache.activemq.spring.ActiveMQConnectionFactory.DEFAULT_BROKER_URL;
    private boolean useSingleConnection = false;
    private boolean usePooledConnection = true;
    private String userName;
    private String password;
    private ActiveMQComponent activeMQComponent;

    public String getBrokerURL() {
        return this.brokerURL;
    }

    public void setBrokerURL(String brokerURL) {
        this.brokerURL = brokerURL;
    }

    public boolean isUseSingleConnection() {
        return this.useSingleConnection;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUseSingleConnection(boolean useSingleConnection) {
        this.useSingleConnection = useSingleConnection;
    }

    public boolean isUsePooledConnection() {
        return this.usePooledConnection;
    }

    public void setUsePooledConnection(boolean usePooledConnection) {
        this.usePooledConnection = usePooledConnection;
    }

    protected PlatformTransactionManager createTransactionManager() {
        JmsTransactionManager answer = new JmsTransactionManager(this.getConnectionFactory());
        answer.afterPropertiesSet();
        return answer;
    }

    protected void setActiveMQComponent(ActiveMQComponent activeMQComponent) {
        this.activeMQComponent = activeMQComponent;
    }

    protected ConnectionFactory createConnectionFactory() {
        org.apache.activemq.spring.ActiveMQConnectionFactory answer = new org.apache.activemq.spring.ActiveMQConnectionFactory();
        if (this.userName != null) {
            answer.setUserName(this.userName);
        }
        if (this.password != null) {
            answer.setPassword(this.password);
        }
        if (answer.getBeanName() == null) {
            answer.setBeanName("Camel");
        }
        answer.setBrokerURL(this.getBrokerURL());
        if (this.isUseSingleConnection()) {
            SingleConnectionFactory scf = new SingleConnectionFactory((ConnectionFactory)answer);
            if (this.activeMQComponent != null) {
                this.activeMQComponent.addSingleConnectionFactory(scf);
            }
            return scf;
        }
        if (this.isUsePooledConnection()) {
            ConnectionFactory pcf = this.createPooledConnectionFactory(answer);
            if (this.activeMQComponent != null) {
                this.activeMQComponent.addPooledConnectionFactoryService((Service)((Object)pcf));
            }
            return pcf;
        }
        return answer;
    }

    protected ConnectionFactory createPooledConnectionFactory(org.apache.activemq.spring.ActiveMQConnectionFactory connectionFactory) {
        try {
            Class<?> type = ActiveMQConfiguration.loadClass("org.apache.activemq.pool.PooledConnectionFactory", ((Object)((Object)this)).getClass().getClassLoader());
            Constructor<?> constructor = type.getConstructor(ActiveMQConnectionFactory.class);
            return (ConnectionFactory)constructor.newInstance(connectionFactory);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate PooledConnectionFactory: " + e, e);
        }
    }

    public static Class<?> loadClass(String name, ClassLoader loader) throws ClassNotFoundException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            try {
                return contextClassLoader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                return loader.loadClass(name);
            }
        }
        return loader.loadClass(name);
    }
}

