/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jms.pool;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.XAConnection;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.activemq.jms.pool.ConnectionPool;
import org.apache.activemq.jms.pool.PooledSession;
import org.apache.activemq.jms.pool.SessionKey;

public class XaConnectionPool
extends ConnectionPool {
    private final TransactionManager transactionManager;

    public XaConnectionPool(Connection connection, TransactionManager transactionManager) {
        super(connection);
        this.transactionManager = transactionManager;
    }

    @Override
    protected Session makeSession(SessionKey key) throws JMSException {
        return ((XAConnection)this.connection).createXASession();
    }

    @Override
    public Session createSession(boolean transacted, int ackMode) throws JMSException {
        try {
            boolean isXa;
            boolean bl = isXa = this.transactionManager != null && this.transactionManager.getStatus() != 6;
            if (isXa) {
                transacted = false;
                ackMode = 2;
            } else if (this.transactionManager != null) {
                transacted = false;
                if (ackMode == 0) {
                    ackMode = 1;
                }
            }
            PooledSession session = (PooledSession)super.createSession(transacted, ackMode);
            if (isXa) {
                session.setIgnoreClose(true);
                session.setIsXa(true);
                this.transactionManager.getTransaction().registerSynchronization(new Synchronization(session));
                this.incrementReferenceCount();
                this.transactionManager.getTransaction().enlistResource(this.createXaResource(session));
            } else {
                session.setIgnoreClose(false);
            }
            return session;
        }
        catch (RollbackException e) {
            JMSException jmsException = new JMSException("Rollback Exception");
            jmsException.initCause(e);
            throw jmsException;
        }
        catch (SystemException e) {
            JMSException jmsException = new JMSException("System Exception");
            jmsException.initCause(e);
            throw jmsException;
        }
    }

    protected XAResource createXaResource(PooledSession session) throws JMSException {
        return session.getXAResource();
    }

    protected class Synchronization
    implements javax.transaction.Synchronization {
        private final PooledSession session;

        private Synchronization(PooledSession session) {
            this.session = session;
        }

        @Override
        public void beforeCompletion() {
        }

        @Override
        public void afterCompletion(int status2) {
            try {
                this.session.setIgnoreClose(false);
                this.session.close();
                XaConnectionPool.this.decrementReferenceCount();
            }
            catch (JMSException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

