/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.discovery.http;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.activemq.transport.discovery.http.HTTPDiscoveryAgent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryRegistryServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(HTTPDiscoveryAgent.class);
    long maxKeepAge = 3600000L;
    ConcurrentHashMap<String, ConcurrentHashMap<String, Long>> serviceGroups = new ConcurrentHashMap();

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String group = req.getPathInfo();
        String service = req.getHeader("service");
        LOG.debug("Registering: group=" + group + ", service=" + service);
        ConcurrentHashMap<String, Long> services = this.getServiceGroup(group);
        services.put(service, System.currentTimeMillis());
    }

    private ConcurrentHashMap<String, Long> getServiceGroup(String group) {
        ConcurrentHashMap<String, Long> rc = this.serviceGroups.get(group);
        if (rc == null) {
            rc = new ConcurrentHashMap();
            this.serviceGroups.put(group, rc);
        }
        return rc;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            long freshness = 30000L;
            String p = req.getParameter("freshness");
            if (p != null) {
                freshness = Long.parseLong(p);
            }
            String group = req.getPathInfo();
            LOG.debug("group=" + group);
            ConcurrentHashMap<String, Long> services = this.getServiceGroup(group);
            PrintWriter writer = resp.getWriter();
            long now = System.currentTimeMillis();
            long dropTime = now - this.maxKeepAge;
            long minimumTime = now - freshness;
            ArrayList<String> dropList = new ArrayList<String>();
            for (Map.Entry<String, Long> entry : services.entrySet()) {
                if (entry.getValue() > minimumTime) {
                    writer.println(entry.getKey());
                    continue;
                }
                if (entry.getValue() >= dropTime) continue;
                dropList.add(entry.getKey());
            }
            for (String service : dropList) {
                services.remove(service);
            }
        }
        catch (Exception e) {
            resp.sendError(500, "Error occured: " + e);
        }
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String group = req.getPathInfo();
        String service = req.getHeader("service");
        LOG.debug("Unregistering: group=" + group + ", service=" + service);
        ConcurrentHashMap<String, Long> services = this.getServiceGroup(group);
        services.remove(service);
    }
}

