/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.io.IOException;
import org.apache.activemq.command.WireFormatInfo;
import org.apache.activemq.transport.AbstractInactivityMonitor;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.wireformat.WireFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StompInactivityMonitor
extends AbstractInactivityMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(StompInactivityMonitor.class);
    private boolean isConfigured = false;

    public StompInactivityMonitor(Transport next, WireFormat wireFormat) {
        super(next, wireFormat);
    }

    public void startMonitoring() throws IOException {
        this.isConfigured = true;
        this.startMonitorThreads();
    }

    @Override
    protected void processInboundWireFormatInfo(WireFormatInfo info) throws IOException {
    }

    @Override
    protected void processOutboundWireFormatInfo(WireFormatInfo info) throws IOException {
    }

    @Override
    protected boolean configuredOk() throws IOException {
        if (!this.isConfigured) {
            return false;
        }
        LOG.debug("Stomp Inactivity Monitor read check interval: {}ms, write check interval: {}ms", (Object)this.getReadCheckTime(), (Object)this.getWriteCheckTime());
        return this.getReadCheckTime() >= 0L && this.getWriteCheckTime() >= 0L;
    }
}

