/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.language.simple.SimpleLanguage;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ResourceHelper;

public class SimpleBuilder
implements Predicate,
Expression {
    private final String text;
    private Class<?> resultType;
    private volatile Expression expression;
    private volatile Predicate predicate;

    public SimpleBuilder(String text) {
        this.text = text;
    }

    public static SimpleBuilder simple(String text) {
        return new SimpleBuilder(text);
    }

    public static SimpleBuilder simple(String text, Class<?> resultType) {
        SimpleBuilder answer = SimpleBuilder.simple(text);
        answer.setResultType(resultType);
        return answer;
    }

    public String getText() {
        return this.text;
    }

    public Class<?> getResultType() {
        return this.resultType;
    }

    public void setResultType(Class<?> resultType) {
        this.resultType = resultType;
    }

    public SimpleBuilder resultType(Class<?> resultType) {
        this.setResultType(resultType);
        return this;
    }

    @Override
    public boolean matches(Exchange exchange) {
        if (this.predicate == null) {
            this.predicate = this.createPredicate(exchange);
        }
        return this.predicate.matches(exchange);
    }

    @Override
    public <T> T evaluate(Exchange exchange, Class<T> type) {
        if (this.expression == null) {
            this.expression = this.createExpression(exchange);
        }
        return this.expression.evaluate(exchange, type);
    }

    private Predicate createPredicate(Exchange exchange) {
        SimpleLanguage simple = (SimpleLanguage)exchange.getContext().resolveLanguage("simple");
        try {
            String resolve = exchange.getContext().resolvePropertyPlaceholders(this.text);
            resolve = ResourceHelper.resolveOptionalExternalScript(exchange.getContext(), resolve);
            return simple.createPredicate(resolve);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapCamelExecutionException(exchange, e);
        }
    }

    private Expression createExpression(Exchange exchange) {
        SimpleLanguage simple = (SimpleLanguage)exchange.getContext().resolveLanguage("simple");
        try {
            String resolve = exchange.getContext().resolvePropertyPlaceholders(this.text);
            resolve = ResourceHelper.resolveOptionalExternalScript(exchange.getContext(), resolve);
            return simple.createExpression(resolve, this.resultType);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapCamelExecutionException(exchange, e);
        }
    }

    public String toString() {
        return "Simple: " + this.text;
    }
}

