/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import org.apache.camel.CamelException;

public class FailedToCreateRouteException
extends CamelException {
    private static final long serialVersionUID = 1L;
    private final String routeId;

    public FailedToCreateRouteException(String routeId, String route, Throwable cause) {
        super("Failed to create route " + routeId + ": " + FailedToCreateRouteException.getRouteMessage(route) + " because of " + FailedToCreateRouteException.getExceptionMessage(cause), cause);
        this.routeId = routeId;
    }

    public FailedToCreateRouteException(String routeId, String route, String at, Throwable cause) {
        super("Failed to create route " + routeId + " at: >>> " + at + " <<< in route: " + FailedToCreateRouteException.getRouteMessage(route) + " because of " + cause.getMessage(), cause);
        this.routeId = routeId;
    }

    public String getRouteId() {
        return this.routeId;
    }

    protected static String getExceptionMessage(Throwable cause) {
        if (cause.getMessage() != null) {
            return cause.getMessage();
        }
        return cause.getClass().getSimpleName();
    }

    protected static String getRouteMessage(String route) {
        if (route.length() > 60) {
            return route.substring(0, 60) + "...";
        }
        return route;
    }
}

