/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public final class RestConsumerContextPathMatcher {
    private RestConsumerContextPathMatcher() {
    }

    public static boolean matchPath(String requestPath, String consumerPath, boolean matchOnUriPrefix) {
        String p2;
        String p1;
        if (requestPath == null && consumerPath == null) {
            return true;
        }
        if (requestPath == null || consumerPath == null) {
            return false;
        }
        if (requestPath.startsWith("/")) {
            requestPath = requestPath.substring(1);
        }
        if (requestPath.endsWith("/")) {
            requestPath = requestPath.substring(0, requestPath.length() - 1);
        }
        if (consumerPath.startsWith("/")) {
            consumerPath = consumerPath.substring(1);
        }
        if (consumerPath.endsWith("/")) {
            consumerPath = consumerPath.substring(0, consumerPath.length() - 1);
        }
        if ((p1 = requestPath.toLowerCase(Locale.ENGLISH)).equals(p2 = consumerPath.toLowerCase(Locale.ENGLISH))) {
            return true;
        }
        return matchOnUriPrefix && p1.startsWith(p2);
    }

    public static ConsumerPath matchBestPath(String requestMethod, String requestPath, List<ConsumerPath> consumerPaths) {
        boolean noWildcards;
        ConsumerPath answer = null;
        ArrayList<ConsumerPath> candidates = new ArrayList<ConsumerPath>();
        for (ConsumerPath entry : consumerPaths) {
            if (!RestConsumerContextPathMatcher.matchRestMethod(requestMethod, entry.getRestrictMethod())) continue;
            candidates.add(entry);
        }
        for (ConsumerPath consumer : candidates) {
            if (!RestConsumerContextPathMatcher.matchRestPath(requestPath, consumer.getConsumerPath(), false)) continue;
            answer = consumer;
            break;
        }
        if (answer == null && RestConsumerContextPathMatcher.isOptionsMethod(requestMethod)) {
            candidates.clear();
            candidates.addAll(consumerPaths);
            for (ConsumerPath consumer : candidates) {
                if (!RestConsumerContextPathMatcher.matchRestPath(requestPath, consumer.getConsumerPath(), false)) continue;
                answer = consumer;
                break;
            }
        }
        if (noWildcards = candidates.stream().allMatch(p -> RestConsumerContextPathMatcher.countWildcards(p.getConsumerPath()) == 0)) {
            answer = candidates.stream().filter(c -> RestConsumerContextPathMatcher.matchPath(requestPath, c.getConsumerPath(), c.isMatchOnUriPrefix())).sorted(Comparator.comparingInt(o -> -1 * o.getConsumerPath().length())).findFirst().orElse(null);
        }
        if (answer == null) {
            Iterator it = candidates.iterator();
            while (it.hasNext()) {
                ConsumerPath consumer = (ConsumerPath)it.next();
                if (RestConsumerContextPathMatcher.matchRestPath(requestPath, consumer.getConsumerPath(), true)) continue;
                it.remove();
            }
            int bestWildcard = Integer.MAX_VALUE;
            ConsumerPath best = null;
            if (candidates.size() > 1) {
                for (ConsumerPath entry : candidates) {
                    int wildcards = RestConsumerContextPathMatcher.countWildcards(entry.getConsumerPath());
                    if (wildcards <= 0 || best != null && wildcards >= bestWildcard) continue;
                    best = entry;
                    bestWildcard = wildcards;
                }
                if (best != null) {
                    answer = best;
                }
            }
            if (answer == null && candidates.size() == 1) {
                answer = (ConsumerPath)candidates.get(0);
            }
        }
        return answer;
    }

    private static boolean matchRestMethod(String method, String restrict) {
        if (restrict == null) {
            return true;
        }
        return restrict.toLowerCase(Locale.ENGLISH).contains(method.toLowerCase(Locale.ENGLISH));
    }

    private static boolean isOptionsMethod(String method) {
        return "options".equalsIgnoreCase(method);
    }

    private static boolean matchRestPath(String requestPath, String consumerPath, boolean wildcard) {
        String[] consumerPaths;
        String[] requestPaths;
        if (requestPath == null && consumerPath == null) {
            return true;
        }
        if (requestPath == null || consumerPath == null) {
            return false;
        }
        if (requestPath.startsWith("/")) {
            requestPath = requestPath.substring(1);
        }
        if (requestPath.endsWith("/")) {
            requestPath = requestPath.substring(0, requestPath.length() - 1);
        }
        if (consumerPath.startsWith("/")) {
            consumerPath = consumerPath.substring(1);
        }
        if (consumerPath.endsWith("/")) {
            consumerPath = consumerPath.substring(0, consumerPath.length() - 1);
        }
        if ((requestPaths = requestPath.split("/")).length != (consumerPaths = consumerPath.split("/")).length) {
            return false;
        }
        for (int i = 0; i < requestPaths.length; ++i) {
            String p1 = requestPaths[i];
            String p2 = consumerPaths[i];
            if (wildcard && p2.startsWith("{") && p2.endsWith("}") || RestConsumerContextPathMatcher.matchPath(p1, p2, false)) continue;
            return false;
        }
        return true;
    }

    private static int countWildcards(String consumerPath) {
        String[] consumerPaths;
        int wildcards = 0;
        if (consumerPath.startsWith("/")) {
            consumerPath = consumerPath.substring(1);
        }
        if (consumerPath.endsWith("/")) {
            consumerPath = consumerPath.substring(0, consumerPath.length() - 1);
        }
        for (String p2 : consumerPaths = consumerPath.split("/")) {
            if (!p2.startsWith("{") || !p2.endsWith("}")) continue;
            ++wildcards;
        }
        return wildcards;
    }

    public static interface ConsumerPath<T> {
        public String getRestrictMethod();

        public String getConsumerPath();

        public T getConsumer();

        public boolean isMatchOnUriPrefix();
    }
}

