/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.mqtt;

import java.io.IOException;
import java.security.cert.X509Certificate;
import javax.jms.JMSException;
import org.apache.activemq.broker.BrokerContext;
import org.apache.activemq.command.Command;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFilter;
import org.apache.activemq.transport.TransportListener;
import org.apache.activemq.transport.mqtt.MQTTInactivityMonitor;
import org.apache.activemq.transport.mqtt.MQTTProtocolConverter;
import org.apache.activemq.transport.mqtt.MQTTTransport;
import org.apache.activemq.transport.mqtt.MQTTWireFormat;
import org.apache.activemq.transport.tcp.SslTransport;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.wireformat.WireFormat;
import org.fusesource.mqtt.codec.MQTTFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTTTransportFilter
extends TransportFilter
implements MQTTTransport {
    private static final Logger LOG = LoggerFactory.getLogger(MQTTTransportFilter.class);
    private static final Logger TRACE = LoggerFactory.getLogger(MQTTTransportFilter.class.getPackage().getName() + ".MQTTIO");
    private final MQTTProtocolConverter protocolConverter;
    private MQTTInactivityMonitor monitor;
    private MQTTWireFormat wireFormat;
    private boolean trace;

    public MQTTTransportFilter(Transport next, WireFormat wireFormat, BrokerContext brokerContext) {
        super(next);
        this.protocolConverter = new MQTTProtocolConverter(this, brokerContext);
        if (wireFormat instanceof MQTTWireFormat) {
            this.wireFormat = (MQTTWireFormat)wireFormat;
        }
    }

    @Override
    public void oneway(Object o) throws IOException {
        try {
            Command command = (Command)o;
            this.protocolConverter.onActiveMQCommand(command);
        }
        catch (Exception e) {
            throw IOExceptionSupport.create(e);
        }
    }

    @Override
    public void onCommand(Object command) {
        try {
            if (this.trace) {
                TRACE.trace("Received: \n" + command);
            }
            this.protocolConverter.onMQTTCommand((MQTTFrame)command);
        }
        catch (IOException e) {
            this.handleException(e);
        }
        catch (JMSException e) {
            this.onException(IOExceptionSupport.create(e));
        }
    }

    @Override
    public void sendToActiveMQ(Command command) {
        TransportListener l = this.transportListener;
        if (l != null) {
            l.onCommand(command);
        }
    }

    @Override
    public void sendToMQTT(MQTTFrame command) throws IOException {
        Transport n;
        if (this.trace) {
            TRACE.trace("Sending: \n" + command);
        }
        if ((n = this.next) != null) {
            n.oneway(command);
        }
    }

    @Override
    public X509Certificate[] getPeerCertificates() {
        if (this.next instanceof SslTransport) {
            X509Certificate[] peerCerts = ((SslTransport)this.next).getPeerCertificates();
            if (this.trace && peerCerts != null) {
                LOG.debug("Peer Identity has been verified\n");
            }
            return peerCerts;
        }
        return null;
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    @Override
    public MQTTInactivityMonitor getInactivityMonitor() {
        return this.monitor;
    }

    public void setInactivityMonitor(MQTTInactivityMonitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public MQTTWireFormat getWireFormat() {
        return this.wireFormat;
    }

    public void handleException(IOException e) {
        this.protocolConverter.onTransportError();
        super.onException(e);
    }
}

