/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb.disk.journal;

import java.io.File;
import java.io.IOException;
import org.apache.activemq.store.kahadb.disk.util.LinkedNode;
import org.apache.activemq.store.kahadb.disk.util.SequenceSet;
import org.apache.activemq.util.IOHelper;
import org.apache.activemq.util.RecoverableRandomAccessFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataFile
extends LinkedNode<DataFile>
implements Comparable<DataFile> {
    private static final Logger LOG = LoggerFactory.getLogger(DataFile.class);
    protected final File file;
    protected final Integer dataFileId;
    protected volatile int length;
    protected final SequenceSet corruptedBlocks = new SequenceSet();

    DataFile(File file, int number) {
        this.file = file;
        this.dataFileId = number;
        this.length = (int)(file.exists() ? file.length() : 0L);
    }

    public File getFile() {
        return this.file;
    }

    public Integer getDataFileId() {
        return this.dataFileId;
    }

    public synchronized int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public synchronized void incrementLength(int size) {
        this.length += size;
    }

    public synchronized String toString() {
        return this.file.getName() + " number = " + this.dataFileId + " , length = " + this.length;
    }

    public synchronized RecoverableRandomAccessFile openRandomAccessFile() throws IOException {
        return new RecoverableRandomAccessFile(this.file.getCanonicalPath(), "rw");
    }

    public synchronized void closeRandomAccessFile(RecoverableRandomAccessFile file) throws IOException {
        file.close();
    }

    public synchronized boolean delete() throws IOException {
        return this.file.delete();
    }

    public synchronized void move(File targetDirectory) throws IOException {
        IOHelper.moveFile((File)this.file, (File)targetDirectory);
    }

    public SequenceSet getCorruptedBlocks() {
        return this.corruptedBlocks;
    }

    @Override
    public int compareTo(DataFile df) {
        return this.dataFileId - df.dataFileId;
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof DataFile) {
            result = this.compareTo((DataFile)o) == 0;
        }
        return result;
    }

    public int hashCode() {
        return this.dataFileId;
    }
}

