/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.mqtt;

import java.io.IOException;
import javax.jms.JMSException;
import org.apache.activemq.transport.tcp.TcpTransport;
import org.fusesource.hawtbuf.DataByteArrayInputStream;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;
import org.fusesource.mqtt.codec.MQTTFrame;

public class MQTTCodec {
    TcpTransport transport;
    DataByteArrayOutputStream currentCommand = new DataByteArrayOutputStream();
    boolean processedHeader = false;
    String action;
    byte header;
    int contentLength = -1;
    int previousByte = -1;
    int payLoadRead = 0;

    public MQTTCodec(TcpTransport transport) {
        this.transport = transport;
    }

    public void parse(DataByteArrayInputStream input, int readSize) throws Exception {
        int i = 0;
        while (i++ < readSize) {
            byte b = input.readByte();
            if (!this.processedHeader && b == 0) {
                this.previousByte = 0;
                continue;
            }
            if (!this.processedHeader) {
                i += this.processHeader(b, input);
                if (this.contentLength == 0) {
                    this.processCommand();
                }
            } else if (this.contentLength == -1) {
                if (b == 0) {
                    this.processCommand();
                } else {
                    this.currentCommand.write((int)b);
                }
            } else if (this.payLoadRead == this.contentLength) {
                this.processCommand();
                i += this.processHeader(b, input);
            } else {
                this.currentCommand.write((int)b);
                ++this.payLoadRead;
            }
            this.previousByte = b;
        }
        if (this.processedHeader && this.payLoadRead == this.contentLength) {
            this.processCommand();
        }
    }

    private int processHeader(byte header, DataByteArrayInputStream input) {
        byte digit;
        this.header = header;
        int multiplier = 1;
        int read = 0;
        int length = 0;
        do {
            digit = input.readByte();
            length += (digit & 0x7F) * multiplier;
            multiplier <<= 7;
            ++read;
        } while ((digit & 0x80) != 0);
        this.contentLength = length;
        this.processedHeader = true;
        return read;
    }

    private void processCommand() throws Exception {
        MQTTFrame frame = new MQTTFrame(this.currentCommand.toBuffer().deepCopy()).header(this.header);
        this.transport.doConsume((Object)frame);
        this.processedHeader = false;
        this.currentCommand.reset();
        this.contentLength = -1;
        this.payLoadRead = 0;
    }

    public static String commandType(byte header) throws IOException, JMSException {
        byte messageType = (byte)((header & 0xF0) >>> 4);
        switch (messageType) {
            case 12: {
                return "PINGREQ";
            }
            case 1: {
                return "CONNECT";
            }
            case 14: {
                return "DISCONNECT";
            }
            case 8: {
                return "SUBSCRIBE";
            }
            case 10: {
                return "UNSUBSCRIBE";
            }
            case 3: {
                return "PUBLISH";
            }
            case 4: {
                return "PUBACK";
            }
            case 5: {
                return "PUBREC";
            }
            case 6: {
                return "PUBREL";
            }
            case 7: {
                return "PUBCOMP";
            }
        }
        return "UNKNOWN";
    }
}

