/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb.disk.journal;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.activemq.store.kahadb.disk.journal.DataFile;
import org.apache.activemq.store.kahadb.disk.journal.FileAppender;
import org.apache.activemq.store.kahadb.disk.journal.Journal;
import org.apache.activemq.store.kahadb.disk.journal.Location;
import org.apache.activemq.store.kahadb.disk.util.LinkedNodeList;
import org.apache.activemq.util.ByteSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DataFileAppender
implements FileAppender {
    private static final Logger logger = LoggerFactory.getLogger(DataFileAppender.class);
    protected final Journal journal;
    protected final Map<Journal.WriteKey, Journal.WriteCommand> inflightWrites;
    protected final Object enqueueMutex = new Object();
    protected WriteBatch nextWriteBatch;
    protected boolean shutdown;
    protected IOException firstAsyncException;
    protected final CountDownLatch shutdownDone = new CountDownLatch(1);
    protected int maxWriteBatchSize;
    protected final boolean syncOnComplete;
    protected boolean running;
    private Thread thread;
    int statIdx = 0;
    int[] stats = new int[maxStat];

    public DataFileAppender(Journal dataManager) {
        this.journal = dataManager;
        this.inflightWrites = this.journal.getInflightWrites();
        this.maxWriteBatchSize = this.journal.getWriteBatchSize();
        this.syncOnComplete = this.journal.isEnableAsyncDiskSync();
    }

    @Override
    public Location storeItem(ByteSequence data, byte type, boolean sync) throws IOException {
        int size2 = data.getLength() + 5;
        Location location = new Location();
        location.setSize(size2);
        location.setType(type);
        Journal.WriteCommand write2 = new Journal.WriteCommand(location, data, sync);
        WriteBatch batch = this.enqueue(write2);
        location.setLatch(batch.latch);
        if (sync) {
            try {
                batch.latch.await();
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
            IOException exception = batch.exception.get();
            if (exception != null) {
                throw exception;
            }
        }
        return location;
    }

    @Override
    public Location storeItem(ByteSequence data, byte type, Runnable onComplete2) throws IOException {
        int size2 = data.getLength() + 5;
        Location location = new Location();
        location.setSize(size2);
        location.setType(type);
        Journal.WriteCommand write2 = new Journal.WriteCommand(location, data, onComplete2);
        WriteBatch batch = this.enqueue(write2);
        location.setLatch(batch.latch);
        return location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WriteBatch enqueue(Journal.WriteCommand write2) throws IOException {
        Object object = this.enqueueMutex;
        synchronized (object) {
            block14: {
                if (this.shutdown) {
                    throw new IOException("Async Writter Thread Shutdown");
                }
                if (!this.running) {
                    this.running = true;
                    this.thread = new Thread(){

                        @Override
                        public void run() {
                            DataFileAppender.this.processQueue();
                        }
                    };
                    this.thread.setPriority(10);
                    this.thread.setDaemon(true);
                    this.thread.setName("ActiveMQ Data File Writer");
                    this.thread.start();
                    this.firstAsyncException = null;
                }
                if (this.firstAsyncException != null) {
                    throw this.firstAsyncException;
                }
                do {
                    if (this.nextWriteBatch == null) {
                        DataFile file = this.journal.getCurrentWriteFile();
                        if (file.getLength() > this.journal.getMaxFileLength()) {
                            file = this.journal.rotateWriteFile();
                        }
                        this.nextWriteBatch = this.newWriteBatch(write2, file);
                        this.enqueueMutex.notifyAll();
                        break block14;
                    }
                    if (this.nextWriteBatch.canAppend(write2)) {
                        this.nextWriteBatch.append(write2);
                        break block14;
                    }
                    try {
                        while (this.nextWriteBatch != null) {
                            long start2 = System.currentTimeMillis();
                            this.enqueueMutex.wait();
                            if (maxStat <= 0) continue;
                            logger.info("Watiting for write to finish with full batch... millis: " + (System.currentTimeMillis() - start2));
                        }
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedIOException();
                    }
                } while (!this.shutdown);
                throw new IOException("Async Writter Thread Shutdown");
            }
            if (!write2.sync) {
                this.inflightWrites.put(new Journal.WriteKey(write2.location), write2);
            }
            return this.nextWriteBatch;
        }
    }

    protected WriteBatch newWriteBatch(Journal.WriteCommand write2, DataFile file) throws IOException {
        return new WriteBatch(file, file.getLength(), write2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.enqueueMutex;
        synchronized (object) {
            if (!this.shutdown) {
                this.shutdown = true;
                if (this.running) {
                    this.enqueueMutex.notifyAll();
                } else {
                    this.shutdownDone.countDown();
                }
            }
        }
        try {
            this.shutdownDone.await();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
    }

    /*
     * Exception decompiling
     */
    protected void processQueue() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [24[UNCONDITIONALDOLOOP]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void signalDone(WriteBatch wb) {
        for (Journal.WriteCommand write2 = wb.writes.getHead(); write2 != null; write2 = (Journal.WriteCommand)write2.getNext()) {
            if (!write2.sync) {
                this.inflightWrites.remove(new Journal.WriteKey(write2.location));
            }
            if (write2.onComplete == null) continue;
            try {
                write2.onComplete.run();
                continue;
            }
            catch (Throwable e) {
                logger.info("Add exception was raised while executing the run command for onComplete", e);
            }
        }
        wb.latch.countDown();
    }

    public class WriteBatch {
        public final DataFile dataFile;
        public final LinkedNodeList<Journal.WriteCommand> writes = new LinkedNodeList();
        public final CountDownLatch latch = new CountDownLatch(1);
        protected final int offset;
        public int size = Journal.BATCH_CONTROL_RECORD_SIZE;
        public AtomicReference<IOException> exception = new AtomicReference();

        public WriteBatch(DataFile dataFile, int offset) {
            this.dataFile = dataFile;
            this.offset = offset;
            this.dataFile.incrementLength(Journal.BATCH_CONTROL_RECORD_SIZE);
            this.size = Journal.BATCH_CONTROL_RECORD_SIZE;
            DataFileAppender.this.journal.addToTotalLength(Journal.BATCH_CONTROL_RECORD_SIZE);
        }

        public WriteBatch(DataFile dataFile, int offset, Journal.WriteCommand write2) throws IOException {
            this(dataFile, offset);
            this.append(write2);
        }

        public boolean canAppend(Journal.WriteCommand write2) {
            int newSize = this.size + write2.location.getSize();
            return newSize < DataFileAppender.this.maxWriteBatchSize && this.offset + newSize <= DataFileAppender.this.journal.getMaxFileLength();
        }

        public void append(Journal.WriteCommand write2) throws IOException {
            this.writes.addLast(write2);
            write2.location.setDataFileId(this.dataFile.getDataFileId());
            write2.location.setOffset(this.offset + this.size);
            int s = write2.location.getSize();
            this.size += s;
            this.dataFile.incrementLength(s);
            DataFileAppender.this.journal.addToTotalLength(s);
        }
    }

    public static class WriteKey {
        private final int file;
        private final long offset;
        private final int hash;

        public WriteKey(Location item) {
            this.file = item.getDataFileId();
            this.offset = item.getOffset();
            this.hash = (int)((long)this.file ^ this.offset);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj instanceof WriteKey) {
                WriteKey di = (WriteKey)obj;
                return di.file == this.file && di.offset == this.offset;
            }
            return false;
        }
    }
}

