/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.url;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.linkedin.util.text.StringSplitter;
import org.linkedin.util.url.Query;
import org.linkedin.util.url.QueryBuilder;
import org.linkedin.util.url.URL;
import org.linkedin.util.url.URLCodec;

public class URLBuilder
implements URL,
Serializable {
    private static final long serialVersionUID = 1L;
    private static StringSplitter SS = new StringSplitter('/');
    private String _scheme = null;
    private String _userInfo = null;
    private String _host = null;
    private int _port = -1;
    private String _path = null;
    private QueryBuilder _query = null;
    private String _fragment = null;
    private boolean _escapeFragment = true;

    public URLBuilder() {
        this._query = new QueryBuilder();
    }

    private URLBuilder(URLBuilder other) {
        this._scheme = other._scheme;
        this._userInfo = other._userInfo;
        this._host = other._host;
        this._port = other._port;
        this._path = other._path;
        this._query = other._query.deepClone();
        this._fragment = other._fragment;
    }

    @Override
    public String getScheme() {
        return this._scheme;
    }

    public void setScheme(String scheme) {
        this._scheme = scheme;
    }

    @Override
    public boolean getHasScheme() {
        return this._scheme != null;
    }

    @Override
    public String getUserInfo() {
        return this._userInfo;
    }

    public void setUserInfo(String userInfo) {
        this._userInfo = userInfo;
    }

    @Override
    public boolean getHasUserInfo() {
        return this._userInfo != null;
    }

    @Override
    public String getHost() {
        return this._host;
    }

    public void setHost(String host) {
        this._host = host;
    }

    @Override
    public boolean getHasHost() {
        return this._host != null;
    }

    @Override
    public int getPort() {
        return this._port;
    }

    public void setPort(int port) {
        this._port = port;
    }

    @Override
    public boolean getHasPort() {
        return this._port > -1;
    }

    @Override
    public String getPath() {
        return this._path;
    }

    public void setPath(String path) {
        if ("".equals(path)) {
            path = null;
        }
        this._path = path;
    }

    public URLBuilder appendPath(String path) {
        this.appendPath(path, true);
        return this;
    }

    public void appendPath(String path, boolean encodePath) {
        if (path == null) {
            return;
        }
        if (encodePath) {
            path = URLBuilder.urlEncode(path);
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (this._path == null || "".equals(this._path)) {
            StringBuilder sb = new StringBuilder("/");
            sb.append(path);
            this._path = sb.toString();
        } else {
            StringBuilder sb = new StringBuilder(this._path);
            if (this._path.endsWith("/")) {
                sb.append(path);
            } else {
                sb.append('/').append(path);
            }
            this._path = sb.toString();
        }
    }

    @Override
    public boolean getHasPath() {
        return this._path != null && this._path.length() > 0;
    }

    @Override
    public List<String> getPathComponents() {
        if (this.getHasPath()) {
            String path = this.getPath();
            if ("/".equals(path)) {
                return Collections.emptyList();
            }
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            List<String> pathComponents = SS.splitAsList(path);
            ListIterator<String> iter = pathComponents.listIterator();
            while (iter.hasNext()) {
                String pathComponent = iter.next();
                iter.set(URLBuilder.urlDecode(pathComponent));
            }
            return pathComponents;
        }
        return Collections.emptyList();
    }

    @Override
    public String getFragment() {
        return this._fragment;
    }

    public void setFragment(String fragment) {
        this._fragment = fragment;
    }

    public URLBuilder setEscapeFragment(boolean escapeFragment) {
        this._escapeFragment = escapeFragment;
        return this;
    }

    @Override
    public boolean getHasFragment() {
        return this._fragment != null;
    }

    @Override
    public String getQueryString() {
        return this._query.getQuery();
    }

    @Override
    public Query getQuery() {
        return this._query;
    }

    @Override
    public boolean getHasQueryParameters() {
        return this._query.getHasQueryParameters();
    }

    @Override
    public String getURL() {
        String query = this._query.getQuery();
        StringBuilder sb = new StringBuilder();
        if (this._scheme != null) {
            sb.append(this._scheme);
            sb.append(':');
        }
        if (this._host != null) {
            boolean needBrackets;
            sb.append("//");
            if (this._userInfo != null) {
                sb.append(this._userInfo);
                sb.append('@');
            }
            boolean bl = needBrackets = this._host.indexOf(58) >= 0 && !this._host.startsWith("[") && !this._host.endsWith("]");
            if (needBrackets) {
                sb.append('[');
            }
            sb.append(this._host);
            if (needBrackets) {
                sb.append(']');
            }
            if (this._port != -1) {
                sb.append(':');
                sb.append(this._port);
            }
        }
        if (this._path != null) {
            sb.append(this._path);
        }
        if (!"".equals(query)) {
            sb.append('?').append(query);
        }
        if (this._fragment != null) {
            sb.append('#').append(this._escapeFragment ? URLBuilder.urlEncode(this._fragment) : this._fragment);
        }
        return sb.toString();
    }

    @Override
    public java.net.URL toJavaURL() {
        try {
            return new java.net.URL(this.getURL());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public URLBuilder addQueryParameter(String name) {
        this._query.addParameter(name);
        return this;
    }

    public URLBuilder addQueryParameter(String name, String value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null for " + name);
        }
        this._query.addParameter(name, value);
        return this;
    }

    public URLBuilder addQueryParameter(String name, int value) {
        this._query.addParameter(name, value);
        return this;
    }

    public URLBuilder addQueryParameter(String name, boolean value) {
        this._query.addBooleanParameter(name, value);
        return this;
    }

    public URLBuilder addQueryParameter(String name, int[] values) {
        String[] params = new String[values.length];
        int idx = 0;
        if (values.length > 0) {
            for (int value : values) {
                params[idx++] = String.valueOf(value);
            }
            this._query.addParameters(name, params);
        }
        return this;
    }

    public URLBuilder addQueryParameter(String name, String[] values) {
        if (values != null && values.length > 0) {
            this._query.addParameters(name, values);
        }
        return this;
    }

    public URLBuilder addQueryParameter(String name, long value) {
        this._query.addParameter(name, value);
        return this;
    }

    public URLBuilder addQueryIndexedParameter(String name, int value, int index) {
        this._query.addIndexedParameter(name, value, index);
        return this;
    }

    public URLBuilder addQueryIndexedParameter(String name, int value, int ... indices) {
        this._query.addIndexedParameter(name, value, indices);
        return this;
    }

    public URLBuilder addQueryIndexedParameter(String name, String value, int index) {
        this._query.addIndexedParameter(name, value, index);
        return this;
    }

    public URLBuilder addQueryIndexedParameter(String name, String value, int ... indices) {
        this._query.addIndexedParameter(name, value, indices);
        return this;
    }

    public URLBuilder addQueryBooleanParameter(String name, boolean value) {
        this._query.addBooleanParameter(name, value);
        return this;
    }

    public URLBuilder addQueryParameters(Map<String, String[]> parameters) {
        this._query.addParameters(parameters);
        return this;
    }

    public URLBuilder addQuery(String query) throws URISyntaxException {
        this._query.addQuery(query);
        return this;
    }

    public URLBuilder addQuery(Query query) {
        this._query.addQuery(query);
        return this;
    }

    public URLBuilder addQuery(URI uri) {
        this._query.addQuery(uri);
        return this;
    }

    public String getQueryParameter(String name) {
        return this._query.getParameter(name);
    }

    public String[] getQueryParameterValues(String name) {
        return this._query.getParameterValues(name);
    }

    public String[] replaceQueryParameter(String name, String value) {
        return this._query.replaceParameter(name, value);
    }

    public String[] removeQueryParameter(String name) {
        return this._query.removeParameter(name);
    }

    public void removeQueryParameters(String ... names) {
        this._query.removeParameters(names);
    }

    public void reset() {
        this._scheme = null;
        this._userInfo = null;
        this._host = null;
        this._port = -1;
        this._path = null;
        this._query = new QueryBuilder();
        this._fragment = null;
        this._escapeFragment = true;
    }

    public void resetQuery() {
        this._query = new QueryBuilder();
    }

    @Override
    public URL createRelativeURL() {
        URLBuilder url = URLBuilder.createFromPath(this.getPath());
        url.addQuery(this.getQuery());
        url.setFragment(this.getFragment());
        return url;
    }

    public URLBuilder deepClone() {
        return new URLBuilder(this);
    }

    public String toString() {
        return this.getURL();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        URLBuilder that = (URLBuilder)o;
        if (this._port != that._port) {
            return false;
        }
        if (this._fragment != null ? !this._fragment.equals(that._fragment) : that._fragment != null) {
            return false;
        }
        if (this._host != null ? !this._host.equals(that._host) : that._host != null) {
            return false;
        }
        if (this._path != null ? !this._path.equals(that._path) : that._path != null) {
            return false;
        }
        if (!this._query.equals(that._query)) {
            return false;
        }
        if (this._scheme != null ? !this._scheme.equals(that._scheme) : that._scheme != null) {
            return false;
        }
        return !(this._userInfo != null ? !this._userInfo.equals(that._userInfo) : that._userInfo != null);
    }

    public int hashCode() {
        int result = this._scheme != null ? this._scheme.hashCode() : 0;
        result = 29 * result + (this._userInfo != null ? this._userInfo.hashCode() : 0);
        result = 29 * result + (this._host != null ? this._host.hashCode() : 0);
        result = 29 * result + this._port;
        result = 29 * result + (this._path != null ? this._path.hashCode() : 0);
        result = 29 * result + this._query.hashCode();
        result = 29 * result + (this._fragment != null ? this._fragment.hashCode() : 0);
        return result;
    }

    public static String urlEncode(String original) {
        return URLCodec.instance().urlEncode(original);
    }

    public static String urlEncode(String original, String encoding) throws UnsupportedEncodingException {
        return new URLCodec(true, encoding).urlEncode(original);
    }

    public static String urlDecode(String original) {
        return URLCodec.instance().urlDecode(original);
    }

    public static String urlDecode(String original, String encoding) throws UnsupportedEncodingException {
        return new URLCodec(true, encoding).urlDecode(original);
    }

    public static URLBuilder createFromPath(String path) {
        URLBuilder res = new URLBuilder();
        res.setPath(path);
        return res;
    }

    public static URLBuilder createFromURL(String url) throws URISyntaxException {
        if (url == null) {
            return null;
        }
        URI uri = new URI(url = url.trim());
        if (uri.isOpaque()) {
            throw new URISyntaxException(url, "opaque uris not supported");
        }
        URLBuilder res = new URLBuilder();
        res.setScheme(uri.getScheme());
        res.setUserInfo(uri.getUserInfo());
        if (uri.getHost() == null && res.getHasScheme()) {
            try {
                java.net.URL u = new java.net.URL(url);
                res.setHost(u.getHost());
                res.setPort(u.getPort());
            }
            catch (MalformedURLException e) {
                URISyntaxException uex = new URISyntaxException(url, e.getMessage());
                uex.initCause(e);
                throw uex;
            }
        } else {
            res.setHost(uri.getHost());
            res.setPort(uri.getPort());
        }
        res.setPath(uri.getRawPath());
        res.setFragment(uri.getFragment());
        res.addQuery(uri);
        return res;
    }

    public static URLBuilder createFromURL(URL url) {
        if (url == null) {
            return null;
        }
        if (url instanceof URLBuilder) {
            URLBuilder urlBuilder = (URLBuilder)url;
            return urlBuilder.deepClone();
        }
        try {
            return URLBuilder.createFromURL(url.getURL());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("bad url!" + url.getURL());
        }
    }

    public static URL addQueryParameter(URL url, String name, String value) {
        URLBuilder ub = URLBuilder.createFromURL(url);
        ub.addQueryParameter(name, value);
        return ub;
    }

    public static String[] getPathComponents(String requestURI, String servletPath) {
        int servletPathStartPos;
        ArrayList<String> tokens = new ArrayList<String>();
        if (requestURI != null && servletPath != null && servletPath.length() > 0 && (servletPathStartPos = requestURI.indexOf(servletPath)) != -1) {
            String components = requestURI.substring(servletPathStartPos + servletPath.length());
            StringTokenizer st = new StringTokenizer(components, "/");
            while (st.hasMoreTokens()) {
                tokens.add(URLBuilder.urlDecode(st.nextToken()));
            }
        }
        return tokens.toArray(new String[tokens.size()]);
    }
}

