/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import jakarta.jms.JMSException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;

public class ConnectionCloseMultipleTimesConcurrentTest
extends TestCase {
    private ActiveMQConnection connection;
    private ExecutorService executor;
    private int size = 200;

    protected void setUp() throws Exception {
        this.executor = Executors.newFixedThreadPool(20);
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost");
        this.connection = (ActiveMQConnection)factory.createConnection();
        this.connection.start();
    }

    protected void tearDown() throws Exception {
        if (this.connection.isStarted()) {
            this.connection.stop();
        }
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    public void testCloseMultipleTimes() throws Exception {
        this.connection.createSession(false, 1);
        ConnectionCloseMultipleTimesConcurrentTest.assertTrue((boolean)this.connection.isStarted());
        ConnectionCloseMultipleTimesConcurrentTest.assertFalse((boolean)this.connection.isClosed());
        final CountDownLatch latch = new CountDownLatch(this.size);
        for (int i = 0; i < this.size; ++i) {
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        ConnectionCloseMultipleTimesConcurrentTest.this.connection.close();
                        TestCase.assertFalse((boolean)ConnectionCloseMultipleTimesConcurrentTest.this.connection.isStarted());
                        TestCase.assertTrue((boolean)ConnectionCloseMultipleTimesConcurrentTest.this.connection.isClosed());
                        latch.countDown();
                    }
                    catch (JMSException jMSException) {
                        // empty catch block
                    }
                }
            });
        }
        boolean zero = latch.await(20L, TimeUnit.SECONDS);
        ConnectionCloseMultipleTimesConcurrentTest.assertTrue((String)"Should complete all", (boolean)zero);
        this.connection.close();
        ConnectionCloseMultipleTimesConcurrentTest.assertFalse((boolean)this.connection.isStarted());
        ConnectionCloseMultipleTimesConcurrentTest.assertTrue((boolean)this.connection.isClosed());
    }
}

