/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.IllegalStateException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class JmsMessageProcuderClosedTest {
    private Connection connection;
    private MessageProducer producer;
    private Message message;
    private Destination destination;
    private BrokerService brokerService;

    protected BrokerService createBroker() throws Exception {
        BrokerService brokerService = new BrokerService();
        brokerService.setPersistent(false);
        brokerService.setUseJmx(false);
        brokerService.setAdvisorySupport(false);
        return brokerService;
    }

    protected MessageProducer createClosedProducer() throws Exception {
        MessageProducer producer = this.createProducer();
        producer.close();
        return producer;
    }

    protected MessageProducer createProducer() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost?create=false");
        this.connection = factory.createConnection();
        Session session = this.connection.createSession(false, 1);
        this.message = session.createMessage();
        this.destination = session.createTopic("test");
        return session.createProducer(this.destination);
    }

    @Before
    public void setUp() throws Exception {
        this.brokerService = this.createBroker();
        this.brokerService.start();
        this.brokerService.waitUntilStarted();
        this.producer = this.createClosedProducer();
    }

    @After
    public void tearDown() throws Exception {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.brokerService != null) {
            this.brokerService.stop();
            this.brokerService.waitUntilStopped();
        }
    }

    @Test(timeout=30000L)
    public void testClose() throws Exception {
        this.producer.close();
    }

    @Test(timeout=30000L, expected=IllegalStateException.class)
    public void testSetDisableMessageIDFails() throws Exception {
        this.producer.setDisableMessageID(true);
    }

    @Test(timeout=30000L, expected=IllegalStateException.class)
    public void testGetDisableMessageIDFails() throws Exception {
        this.producer.getDisableMessageID();
    }

    @Test(timeout=30000L, expected=IllegalStateException.class)
    public void testSetDisableMessageTimestampFails() throws Exception {
        this.producer.setDisableMessageTimestamp(false);
    }

    @Test(timeout=30000L, expected=IllegalStateException.class)
    public void testGetDisableMessageTimestampFails() throws Exception {
        this.producer.getDisableMessageTimestamp();
    }

    @Test(timeout=30000L, expected=IllegalStateException.class)
    public void testSetDeliveryModeFails() throws Exception {
        this.producer.setDeliveryMode(1);
    }

    @Test(timeout=30000L, expected=IllegalStateException.class)
    public void testGetDeliveryModeFails() throws Exception {
        this.producer.getDeliveryMode();
    }

    @Test(timeout=30000L, expected=IllegalStateException.class)
    public void testSetPriorityFails() throws Exception {
        this.producer.setPriority(1);
    }

    @Test(timeout=30000L, expected=IllegalStateException.class)
    public void testGetPriorityFails() throws Exception {
        this.producer.getPriority();
    }

    @Test(timeout=30000L, expected=IllegalStateException.class)
    public void testSetTimeToLiveFails() throws Exception {
        this.producer.setTimeToLive(1L);
    }

    @Test(timeout=30000L, expected=IllegalStateException.class)
    public void testGetTimeToLiveFails() throws Exception {
        this.producer.getTimeToLive();
    }

    @Test(timeout=30000L, expected=IllegalStateException.class)
    public void testGetDestinationFails() throws Exception {
        this.producer.getDestination();
    }

    @Test(timeout=30000L, expected=IllegalStateException.class)
    public void testSendFails() throws Exception {
        this.producer.send(this.message);
    }

    @Test(timeout=30000L, expected=IllegalStateException.class)
    public void testSendWithDestinationFails() throws Exception {
        this.producer.send(this.destination, this.message);
    }

    @Test(timeout=30000L, expected=IllegalStateException.class)
    public void testSendWithModePriorityTTLFails() throws Exception {
        this.producer.send(this.message, 1, 3, 111L);
    }

    @Test(timeout=30000L, expected=IllegalStateException.class)
    public void testSendWithDestinationModePriorityTTLFails() throws Exception {
        this.producer.send(this.destination, this.message, 1, 3, 111L);
    }
}

