/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import jakarta.jms.Message;
import jakarta.jms.TextMessage;
import org.apache.activemq.JmsTopicSelectorTest;

public class JmsQueueSelectorTest
extends JmsTopicSelectorTest {
    @Override
    public void setUp() throws Exception {
        this.topic = false;
        super.setUp();
    }

    public void testRedeliveryWithSelectors() throws Exception {
        this.consumer = this.createConsumer("");
        TextMessage message = this.session.createTextMessage("1");
        message.setIntProperty("id", 1);
        message.setJMSType("b");
        message.setStringProperty("stringProperty", "b");
        message.setLongProperty("longProperty", 1L);
        message.setBooleanProperty("booleanProperty", true);
        this.producer.send((Message)message);
        this.consumer.close();
        message = this.session.createTextMessage("1");
        message.setIntProperty("id", 1);
        message.setJMSType("a");
        message.setStringProperty("stringProperty", "a");
        message.setLongProperty("longProperty", 1L);
        message.setBooleanProperty("booleanProperty", true);
        this.producer.send((Message)message);
        this.consumer = this.createConsumer("stringProperty = 'a' and longProperty = 1 and booleanProperty = true");
        int remaining = 2;
        Message recievedMsg = null;
        while ((recievedMsg = this.consumer.receive(1000L)) != null) {
            String text = ((TextMessage)recievedMsg).getText();
            if (!text.equals("1") && !text.equals("3")) {
                JmsQueueSelectorTest.fail((String)("unexpected message: " + text));
            }
            --remaining;
        }
        JmsQueueSelectorTest.assertEquals((int)1, (int)remaining);
        this.consumer.close();
        this.consumeMessages(remaining);
    }
}

