/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import jakarta.jms.InvalidClientIDException;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.broker.StubConnection;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.network.NetworkTestSupport;

public class DoubleSubscriptionTest
extends NetworkTestSupport {
    public ActiveMQDestination destination;
    public int deliveryMode;
    private String remoteURI = "tcp://localhost:0?wireFormat.tcpNoDelayEnabled=true";

    public static Test suite() {
        return DoubleSubscriptionTest.suite(DoubleSubscriptionTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)DoubleSubscriptionTest.suite());
    }

    public void initCombosForTestDoubleSubscription() {
        this.addCombinationValues("destination", new Object[]{new ActiveMQQueue("TEST"), new ActiveMQQueue("TEST")});
    }

    public void testDoubleSubscription() throws Exception {
        StubConnection connection1 = this.createRemoteConnection();
        ConnectionInfo connectionInfo1 = this.createConnectionInfo();
        SessionInfo sessionInfo1 = this.createSessionInfo(connectionInfo1);
        ConsumerInfo consumerInfo1 = this.createConsumerInfo(sessionInfo1, this.destination);
        connection1.send((Command)connectionInfo1);
        connection1.send((Command)sessionInfo1);
        connection1.request((Command)consumerInfo1);
        StubConnection connection2 = this.createRemoteConnection();
        ConnectionInfo connectionInfo2 = this.createConnectionInfo();
        SessionInfo sessionInfo2 = this.createSessionInfo(connectionInfo2);
        ProducerInfo producerInfo2 = this.createProducerInfo(sessionInfo2);
        connection2.send((Command)connectionInfo2);
        connection2.send((Command)sessionInfo2);
        connection2.request((Command)producerInfo2);
        connection2.request((Command)this.createMessage(producerInfo2, this.destination, 2));
        Message m1 = this.receiveMessage(connection1);
        DoubleSubscriptionTest.assertNotNull((Object)m1);
        this.assertNoMessagesLeft(connection1);
        connection1.send((Command)this.createAck(consumerInfo1, m1, 1, (byte)2));
        connection2.request((Command)this.createMessage(producerInfo2, this.destination, 2));
        try {
            connection1.send((Command)connectionInfo1);
            connection1.send((Command)sessionInfo1);
            connection1.request((Command)consumerInfo1);
        }
        catch (InvalidClientIDException invalidClientIDException) {
            // empty catch block
        }
        connection2.request((Command)this.createMessage(producerInfo2, this.destination, 2));
        connection1.stop();
        StubConnection connection3 = this.createRemoteConnection();
        ConnectionInfo connectionInfo3 = this.createConnectionInfo();
        SessionInfo sessionInfo3 = this.createSessionInfo(connectionInfo3);
        ConsumerInfo consumerInfo3 = this.createConsumerInfo(sessionInfo3, this.destination);
        connection3.send((Command)connectionInfo3);
        connection3.send((Command)sessionInfo3);
        connection3.request((Command)consumerInfo3);
        DoubleSubscriptionTest.assertNotNull((Object)this.receiveMessage(connection3));
        DoubleSubscriptionTest.assertNotNull((Object)this.receiveMessage(connection3));
        this.assertNoMessagesLeft(connection3);
    }

    @Override
    protected String getRemoteURI() {
        return this.remoteURI;
    }
}

