/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.jmx;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.MessageConsumer;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.jmx.ManagedRegionBroker;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.util.Wait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxConsumerRemovalTest
extends EmbeddedBrokerTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(JmxConsumerRemovalTest.class);
    protected MBeanServer mbeanServer;
    protected ManagedRegionBroker regionBroker;
    protected Session session;
    protected String clientID = "foo";
    protected Connection connection;
    protected boolean transacted;

    public static void main(String[] args) {
        TestRunner.run(JmxConsumerRemovalTest.class);
    }

    public static Test suite() {
        return JmxConsumerRemovalTest.suite(JmxConsumerRemovalTest.class);
    }

    public void testCompositeDestConsumerRemoval() throws Exception {
        Map<Subscription, ObjectName> subscriptionMap = this.getSubscriptionMap();
        int consumersToAdd = 1000;
        HashSet<MessageConsumer> consumers = new HashSet<MessageConsumer>();
        ActiveMQQueue dest = new ActiveMQQueue("test");
        dest.setCompositeDestinations(new ActiveMQDestination[]{new ActiveMQQueue("test1"), new ActiveMQQueue("test2"), new ActiveMQQueue("test3")});
        for (int i = 0; i < consumersToAdd; ++i) {
            consumers.add(this.session.createConsumer((Destination)dest));
        }
        JmxConsumerRemovalTest.assertTrue((boolean)Wait.waitFor(() -> consumersToAdd == subscriptionMap.size(), (long)5000L, (long)500L));
        for (MessageConsumer consumer : consumers) {
            consumer.close();
        }
        JmxConsumerRemovalTest.assertTrue((boolean)Wait.waitFor(() -> 0 == subscriptionMap.size(), (long)5000L, (long)500L));
        JmxConsumerRemovalTest.assertTrue((boolean)Wait.waitFor(() -> 0 == this.regionBroker.getQueueSubscribers().length + this.regionBroker.getTopicSubscribers().length, (long)5000L, (long)500L));
    }

    public void testDurableConsumerRemoval() throws Exception {
        this.testDurableConsumerRemoval((ActiveMQDestination)new ActiveMQTopic("wildcard.topic.1"));
    }

    public void testDurableConsumerWildcardRemoval() throws Exception {
        this.testDurableConsumerRemoval((ActiveMQDestination)new ActiveMQTopic("wildcard.topic.>"));
    }

    public void testDurableConsumerRemoval(ActiveMQDestination dest) throws Exception {
        int consumersToAdd = 1000;
        HashSet<TopicSubscriber> durables = new HashSet<TopicSubscriber>();
        for (int i = 0; i < consumersToAdd; ++i) {
            durables.add(this.session.createDurableSubscriber((Topic)dest, "sub" + i));
        }
        JmxConsumerRemovalTest.assertTrue((boolean)Wait.waitFor(() -> consumersToAdd == this.getSubscriptionMap().size(), (long)5000L, (long)500L));
        for (MessageConsumer messageConsumer : durables) {
            messageConsumer.close();
        }
        JmxConsumerRemovalTest.assertTrue((boolean)Wait.waitFor(() -> 0 == this.regionBroker.getDurableTopicSubscribers().length, (long)5000L, (long)500L));
    }

    public void testQueueConsumerRemoval() throws Exception {
        this.testConsumerRemoval((ActiveMQDestination)new ActiveMQQueue("wildcard.queue.1"));
    }

    public void testQueueConsumerRemovalWildcard() throws Exception {
        this.testConsumerRemoval((ActiveMQDestination)new ActiveMQQueue("wildcard.queue.>"));
    }

    public void testTopicConsumerRemoval() throws Exception {
        this.testConsumerRemoval((ActiveMQDestination)new ActiveMQTopic("wildcard.topic.1"));
    }

    public void testTopicConsumerRemovalWildcard() throws Exception {
        this.testConsumerRemoval((ActiveMQDestination)new ActiveMQTopic("wildcard.topic.>"));
    }

    private void testConsumerRemoval(ActiveMQDestination dest) throws Exception {
        Map<Subscription, ObjectName> subscriptionMap = this.getSubscriptionMap();
        int consumersToAdd = 1000;
        HashSet<MessageConsumer> consumers = new HashSet<MessageConsumer>();
        for (int i = 0; i < consumersToAdd; ++i) {
            consumers.add(this.session.createConsumer((Destination)dest));
        }
        JmxConsumerRemovalTest.assertTrue((boolean)Wait.waitFor(() -> consumersToAdd == subscriptionMap.size(), (long)5000L, (long)500L));
        for (MessageConsumer consumer : consumers) {
            consumer.close();
        }
        JmxConsumerRemovalTest.assertTrue((boolean)Wait.waitFor(() -> 0 == subscriptionMap.size(), (long)5000L, (long)500L));
        JmxConsumerRemovalTest.assertTrue((boolean)Wait.waitFor(() -> 0 == this.regionBroker.getQueueSubscribers().length && 0 == this.regionBroker.getTopicSubscribers().length, (long)5000L, (long)500L));
    }

    private Map<Subscription, ObjectName> getSubscriptionMap() throws Exception {
        ManagedRegionBroker regionBroker = (ManagedRegionBroker)this.broker.getBroker().getAdaptor(ManagedRegionBroker.class);
        Field subMapField = ManagedRegionBroker.class.getDeclaredField("subscriptionMap");
        subMapField.setAccessible(true);
        return (Map)subMapField.get(regionBroker);
    }

    @Override
    protected void setUp() throws Exception {
        this.bindAddress = "tcp://localhost:0";
        this.useTopic = true;
        super.setUp();
        this.mbeanServer = this.broker.getManagementContext().getMBeanServer();
        this.regionBroker = (ManagedRegionBroker)this.broker.getBroker().getAdaptor(ManagedRegionBroker.class);
        ((ActiveMQConnectionFactory)this.connectionFactory).setWatchTopicAdvisories(false);
        this.connection = this.connectionFactory.createConnection();
        this.connection.setClientID(this.clientID);
        this.connection.start();
        this.session = this.connection.createSession(this.transacted, 1);
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
        super.tearDown();
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        answer.setUseJmx(true);
        answer.addConnector(this.bindAddress);
        answer.deleteAllMessages();
        return answer;
    }

    @Override
    protected ConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory(((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString());
    }

    protected void echo(String text) {
        LOG.info(text);
    }

    @Override
    protected String getDestinationString() {
        return ((Object)((Object)this)).getClass().getName() + "." + this.getName(true);
    }
}

